/*
 Modelspoorgroep Venlo LocoNet Firmware
 Copyright (C) Ewout Prangsma <ewout@prangsma.net>
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "eeprom.h"
#include <xc.h>

void writeEEprom(unsigned char address, unsigned char data)
{

while (WR);         // wait until all previous writes are completed (eeprom, flash and config-registers)

GIE = 0;            // Disable Interrupts 

EEADR = address;    // sets address to write
EEDATA = data;      // sets data value to write

WREN = 1;
EECON2 = 0x55;      // Required sequence so says the PIC18F2480 spec on page 107
EECON2 = 0xAA;
WR = 1;             // This begins the write */

while(WR);          // wait for the write action to complete

EEIF = 0;           // clear the interrupt flag
WREN = 0;           // Disable Writes 

}  /* end of function */


unsigned char readEEprom (unsigned char address)
{

    GIE=0;              // Disable Interrupts 

    EEADR=address;      // sets address to write

    RD=1;               // This begins the read action 

    return EEDATA;      // return the EEPROM data byte
}


unsigned int eeprom_read_word (unsigned char address) 
{
	unsigned int value, vLSB;
	
    value = readEEprom(address);            // Read MSB data
    value = value << 8;                     // Shift byte to the MSB position of value
    vLSB  = readEEprom (address + 1);       // Read LSB data 
    value = value + vLSB;                   // MSB + LSB
	return value;                           // Return data
}



void eeprom_write_word (unsigned char address, unsigned int value) 
{    
    writeEEprom (address, (value>>8));      // Write MSB
    writeEEprom ((address + 1), value);     // Write LSB
}