; Compiled with: PIC Simulator IDE v7.37
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	LONG_0 EQU 0x020
	LONG_1 EQU 0x021
	LONG_2 EQU 0x022
	LONG_3 EQU 0x023
	LONG2_0 EQU 0x024
	LONG2_1 EQU 0x025
	LONG2_2 EQU 0x026
	LONG2_3 EQU 0x027
	LONG1 EQU 0x020
	LONG2 EQU 0x024
	W_TEMP EQU 0x07F
	STATUS_TEMP EQU 0x07E
;       The value of 'time' (global) is 40
;       The address of 'halltime1' (byte) (global) is 0x028
;       The address of 'halltime2' (byte) (global) is 0x029
;       The address of 'halltime3' (byte) (global) is 0x02A
;       The address of 'halltime4' (byte) (global) is 0x02B
;       The address of 'halltime5' (byte) (global) is 0x02C
;       The address of 'halltime6' (byte) (global) is 0x02D
;       The address of 'halltime7' (byte) (global) is 0x02E
;       The address of 'halltime8' (byte) (global) is 0x02F
;       The address of 'clock' (byte) (global) is 0x030
;       The address of 'hall1' (bit) (global) is 0x005,1
;       The address of 'hall2' (bit) (global) is 0x005,2
;       The address of 'hall3' (bit) (global) is 0x005,0
;       The address of 'hall4' (bit) (global) is 0x005,3
;       The address of 'hall5' (bit) (global) is 0x005,7
;       The address of 'hall6' (bit) (global) is 0x005,4
;       The address of 'hall7' (bit) (global) is 0x005,6
;       The address of 'hall8' (bit) (global) is 0x005,5
;       The address of 'fb1' (bit) (global) is 0x006,4
;       The address of 'fb2' (bit) (global) is 0x006,5
;       The address of 'fb3' (bit) (global) is 0x006,6
;       The address of 'fb4' (bit) (global) is 0x006,7
;       The address of 'fb5' (bit) (global) is 0x006,3
;       The address of 'fb6' (bit) (global) is 0x006,2
;       The address of 'fb7' (bit) (global) is 0x006,1
;       The address of 'fb8' (bit) (global) is 0x006,0
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0002
	ORG 0x0004
	MOVWF W_TEMP
	SWAPF STATUS,W
	CLRF STATUS
	MOVWF STATUS_TEMP
	CALL L0003
	SWAPF STATUS_TEMP,W
	MOVWF STATUS
	SWAPF W_TEMP,F
	SWAPF W_TEMP,W
	RETFIE
; User code start
L0002:
; 1: 'program GCA173
; 2: 'pulse extender for halldiodes
; 3: 'all outputs are normal high
; 4: 'Output will be low if according input is low for more than 2 mSecs.
; 5: 'output will be high after 200 mSec and input = high.
; 6: '22 march 2016  Definition Freqyency added.
; 7: 
; 8: Define CONF_WORD = 0x3f50
; 9: Define CLOCK_FREQUENCY = 4
; 10: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 11: TRISA = 255
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF TRISA
; 12: TRISB = 0
	CLRF TRISB
	BCF STATUS,RP0
; 13: PORTB = 255
	MOVLW 0xFF
	MOVWF PORTB
; 14: 
; 15: 
; 16: Symbol hall1 = RA1
; 17: Symbol hall2 = RA2
; 18: Symbol hall3 = RA0
; 19: Symbol hall4 = RA3
; 20: Symbol hall5 = RA7
; 21: Symbol hall6 = RA4
; 22: Symbol hall7 = RA6
; 23: Symbol hall8 = RA5
; 24: Symbol fb1 = RB4
; 25: Symbol fb2 = RB5
; 26: Symbol fb3 = RB6
; 27: Symbol fb4 = RB7
; 28: Symbol fb5 = RB3
; 29: Symbol fb6 = RB2
; 30: Symbol fb7 = RB1
; 31: Symbol fb8 = RB0
; 32: Dim halltime1 As Byte
	CLRF 0x028
; 33: Dim halltime2 As Byte
	CLRF 0x029
; 34: Dim halltime3 As Byte
	CLRF 0x02A
; 35: Dim halltime4 As Byte
	CLRF 0x02B
; 36: Dim halltime5 As Byte
	CLRF 0x02C
; 37: Dim halltime6 As Byte
	CLRF 0x02D
; 38: Dim halltime7 As Byte
	CLRF 0x02E
; 39: Dim halltime8 As Byte
	CLRF 0x02F
; 40: Dim clock As Byte
	CLRF 0x030
; 41: Const time = 40  'interrupt  every 250 uSec , timing 80 mSec after hall(x) becomes high
; 42: OPTION_REG.T0CS = 0  'Bit 5 TMR0 clock source Select Bit: 0 = internal clock(clko) / 1 = transition On t0cki pin
	BSF STATUS,RP0
	BCF OPTION_REG,5
; 43: OPTION_REG.T0SE = 0  '; ; Bit 4 TMR0 source edge Select Bit: 0 = Low / High / 1 = High / Low
	BCF OPTION_REG,4
; 44: OPTION_REG.PSA = 0  '; ; Bit 3 prescaler assignment Bit: 0 = prescaler is assigned To the wdt
	BCF OPTION_REG,3
; 45: OPTION_REG.PS2 = 0  '; ; bits 2 - 0 PS2: PS0: prescaler rate Select bits
	BCF OPTION_REG,2
; 46: OPTION_REG.PS1 = 0  ';
	BCF OPTION_REG,1
; 47: OPTION_REG.PS0 = 0  ';
	BCF OPTION_REG,0
	BCF STATUS,RP0
; 48: TMR0 = 6  '; ; preset For timer register
	MOVLW 0x06
	MOVWF TMR0
; 49: INTCON.T0IE = 1  'enable Timer0 interrupts
	BSF INTCON,5
; 50: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF INTCON,2
; 51: INTCON.GIE = True  'enable all un-masked interrupts
	BSF INTCON,7
; 52: OPTION_REG.T0CS = False  'set Timer0 clock source to internal instruction cycle clock
	BSF STATUS,RP0
	BCF OPTION_REG,5
	BCF STATUS,RP0
; 53: main:
L0001:
; 54: 'hallsensor 1
; 55: If hall1 = 0 Then
	BTFSC 0x005,1
	GOTO L0004
; 56: halltime1 = 8
	MOVLW 0x08
	MOVWF 0x028
; 57: fb1 = 0
	BCF PORTB,4
; 58: Else
	GOTO L0005
L0004:
; 59: If halltime1 = 0 Then
	MOVF 0x028,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0006
; 60: fb1 = 1
	BSF PORTB,4
; 61: Endif
L0006:
; 62: Endif
L0005:
; 63: 
; 64: 'hallsensor 2
; 65: If hall2 = 0 Then
	BTFSC 0x005,2
	GOTO L0007
; 66: halltime2 = 8
	MOVLW 0x08
	MOVWF 0x029
; 67: fb2 = 0
	BCF PORTB,5
; 68: Else
	GOTO L0008
L0007:
; 69: If halltime2 = 0 Then
	MOVF 0x029,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0009
; 70: fb2 = 1
	BSF PORTB,5
; 71: Endif
L0009:
; 72: Endif
L0008:
; 73: 
; 74: 'hallsensor 3
; 75: If hall3 = 0 Then
	BTFSC 0x005,0
	GOTO L0010
; 76: halltime3 = 8
	MOVLW 0x08
	MOVWF 0x02A
; 77: fb3 = 0
	BCF PORTB,6
; 78: Else
	GOTO L0011
L0010:
; 79: If halltime3 = 0 Then
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0012
; 80: fb3 = 1
	BSF PORTB,6
; 81: Endif
L0012:
; 82: Endif
L0011:
; 83: 'hallsensor 4
; 84: If hall4 = 0 Then
	BTFSC 0x005,3
	GOTO L0013
; 85: halltime4 = 8
	MOVLW 0x08
	MOVWF 0x02B
; 86: fb4 = 0
	BCF PORTB,7
; 87: Else
	GOTO L0014
L0013:
; 88: If halltime4 = 0 Then
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0015
; 89: fb4 = 1
	BSF PORTB,7
; 90: Endif
L0015:
; 91: Endif
L0014:
; 92: 
; 93: 'hallsensor 5
; 94: If hall5 = 0 Then
	BTFSC 0x005,7
	GOTO L0016
; 95: halltime5 = 8
	MOVLW 0x08
	MOVWF 0x02C
; 96: fb5 = 0
	BCF PORTB,3
; 97: Else
	GOTO L0017
L0016:
; 98: If halltime5 = 0 Then
	MOVF 0x02C,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0018
; 99: fb5 = 1
	BSF PORTB,3
; 100: Endif
L0018:
; 101: Endif
L0017:
; 102: 
; 103: 'hallsensor 6
; 104: If hall6 = 0 Then
	BTFSC 0x005,4
	GOTO L0019
; 105: halltime6 = 8
	MOVLW 0x08
	MOVWF 0x02D
; 106: fb6 = 0
	BCF PORTB,2
; 107: Else
	GOTO L0020
L0019:
; 108: If halltime6 = 0 Then
	MOVF 0x02D,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0021
; 109: fb6 = 1
	BSF PORTB,2
; 110: Endif
L0021:
; 111: Endif
L0020:
; 112: 
; 113: 'hallsensor 7
; 114: If hall7 = 0 Then
	BTFSC 0x005,6
	GOTO L0022
; 115: halltime7 = 8
	MOVLW 0x08
	MOVWF 0x02E
; 116: fb7 = 0
	BCF PORTB,1
; 117: Else
	GOTO L0023
L0022:
; 118: If halltime7 = 0 Then
	MOVF 0x02E,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0024
; 119: fb7 = 1
	BSF PORTB,1
; 120: Endif
L0024:
; 121: Endif
L0023:
; 122: 
; 123: 'hallsensor 8
; 124: If hall8 = 0 Then
	BTFSC 0x005,5
	GOTO L0025
; 125: halltime8 = 8
	MOVLW 0x08
	MOVWF 0x02F
; 126: fb8 = 0
	BCF PORTB,0
; 127: Else
	GOTO L0026
L0025:
; 128: If halltime8 = 0 Then
	MOVF 0x02F,W
	SUBLW 0x00
	BTFSS STATUS,Z
	GOTO L0027
; 129: fb8 = 1
	BSF PORTB,0
; 130: Endif
L0027:
; 131: Endif
L0026:
; 132: If clock = time Then
	MOVF 0x030,W
	SUBLW 0x28
	BTFSS STATUS,Z
	GOTO L0028
; 133: clock = 0
	CLRF 0x030
; 134: If halltime1 > 0 Then
	MOVF 0x028,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0029
; 135: halltime1 = halltime1 - 1
	MOVLW 0x01
	SUBWF 0x028,W
	MOVWF 0x028
; 136: Else
	GOTO L0030
L0029:
; 137: fb1 = 1
	BSF PORTB,4
; 138: Endif
L0030:
; 139: If halltime2 > 0 Then
	MOVF 0x029,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0031
; 140: halltime2 = halltime2 - 1
	MOVLW 0x01
	SUBWF 0x029,W
	MOVWF 0x029
; 141: Else
	GOTO L0032
L0031:
; 142: fb2 = 1
	BSF PORTB,5
; 143: Endif
L0032:
; 144: If halltime3 > 0 Then
	MOVF 0x02A,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0033
; 145: halltime3 = halltime3 - 1
	MOVLW 0x01
	SUBWF 0x02A,W
	MOVWF 0x02A
; 146: Else
	GOTO L0034
L0033:
; 147: fb3 = 1
	BSF PORTB,6
; 148: Endif
L0034:
; 149: If halltime4 > 0 Then
	MOVF 0x02B,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0035
; 150: halltime4 = halltime4 - 1
	MOVLW 0x01
	SUBWF 0x02B,W
	MOVWF 0x02B
; 151: Else
	GOTO L0036
L0035:
; 152: fb4 = 1
	BSF PORTB,7
; 153: Endif
L0036:
; 154: If halltime5 > 0 Then
	MOVF 0x02C,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0037
; 155: halltime5 = halltime5 - 1
	MOVLW 0x01
	SUBWF 0x02C,W
	MOVWF 0x02C
; 156: Else
	GOTO L0038
L0037:
; 157: fb5 = 1
	BSF PORTB,3
; 158: Endif
L0038:
; 159: If halltime6 > 0 Then
	MOVF 0x02D,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0039
; 160: halltime6 = halltime6 - 1
	MOVLW 0x01
	SUBWF 0x02D,W
	MOVWF 0x02D
; 161: Else
	GOTO L0040
L0039:
; 162: fb6 = 1
	BSF PORTB,2
; 163: Endif
L0040:
; 164: If halltime7 > 0 Then
	MOVF 0x02E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0041
; 165: halltime7 = halltime7 - 1
	MOVLW 0x01
	SUBWF 0x02E,W
	MOVWF 0x02E
; 166: Else
	GOTO L0042
L0041:
; 167: fb7 = 1
	BSF PORTB,1
; 168: Endif
L0042:
; 169: If halltime8 > 0 Then
	MOVF 0x02F,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0043
; 170: halltime8 = halltime8 - 1
	MOVLW 0x01
	SUBWF 0x02F,W
	MOVWF 0x02F
; 171: Else
	GOTO L0044
L0043:
; 172: fb8 = 1
	BSF PORTB,0
; 173: Endif
L0044:
; 174: Endif
L0028:
; 175: Goto main
	GOTO L0001
; 176: 
; 177: End
L0045:	GOTO L0045
; 178: On Interrupt
L0003:
; 179: clock = clock + 1
	MOVF 0x030,W
	ADDLW 0x01
	MOVWF 0x030
; 180: INTCON.T0IF = 0  'enable new TMR0 interrupts
	BCF INTCON,2
; 181: Resume
	RETURN
; End of user code
L0046:	GOTO L0046
;
;
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
