; Compiled with: PIC Simulator IDE v9.83
; Microcontroller model: PIC16F628A
; Clock frequency: 4.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R4HL EQU 0x028
;       The address of 'activation_time' (word) (global) is 0x022
;       The address of 'dummy' (byte) (global) is 0x024
;       The address of 'switch' (byte) (global) is 0x025
;       The address of 'ap_1' (bit) (global) is 0x026,0
;       The address of 'ap_2' (bit) (global) is 0x026,1
;       The address of 'ap_3' (bit) (global) is 0x026,2
;       The address of 'ap_4' (bit) (global) is 0x026,3
;       The address of 'switch' (byte) (set_position) is 0x027
;       The address of 'ci1' (bit) (global) is 0x005,0
;       The address of 'ci2' (bit) (global) is 0x005,1
;       The address of 'ci3' (bit) (global) is 0x005,2
;       The address of 'ci4' (bit) (global) is 0x005,5
;       The address of 'fb1' (bit) (global) is 0x005,4
;       The address of 'fb2' (bit) (global) is 0x005,3
;       The address of 'fb3' (bit) (global) is 0x005,6
;       The address of 'fb4' (bit) (global) is 0x005,7
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0005
	ORG 0x0004
	RETFIE
; LookUp Table: (%11000011, %11000110, %11000101, %11001010, %11001001, %11010010, %11010001, %11100010, %11100001)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC3
	RETLW 0xC6
	RETLW 0xC5
	RETLW 0xCA
	RETLW 0xC9
	RETLW 0xD2
	RETLW 0xD1
	RETLW 0xE2
	RETLW 0xE1
; User code start
L0005:
; 1: 'program for GCA79 Version V3 and V4
; 2: 
; 3: #define CONFIG = 0x3f50
;       The value of 'CONFIG' is 16208
; 4: //#define SIMULATION_WAITMS_VALUE = 0
; 5: All_Digital
	MOVLW 0x07
	MOVWF CMCON
	BSF STATUS,RP0
	BCF VRCON,6
	BCF STATUS,RP0
; 6: CMCON = 7
	MOVLW 0x07
	MOVWF CMCON
; 7: TRISA = %00100111
	MOVLW 0x27
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 8: PORTA = %00100111
	MOVLW 0x27
	MOVWF PORTA
; 9: TRISB = %11000000
	MOVLW 0xC0
	BSF STATUS,RP0
	MOVWF TRISB
	BCF STATUS,RP0
; 10: PORTB = %11000000
	MOVLW 0xC0
	MOVWF PORTB
; 11: 
; 12: Dim activation_time As Word
; 13: Dim dummy As Byte
; 14: Dim switch As Byte
; 15: //define actual positons (will be first calculated at start from inputs)
; 16: Dim ap_1 As Bit
; 17: Dim ap_2 As Bit
; 18: Dim ap_3 As Bit
; 19: Dim ap_4 As Bit
; 20: //define command inputs
; 21: Symbol ci1 = PORTA.0
; 22: Symbol ci2 = PORTA.1
; 23: Symbol ci3 = PORTA.2
; 24: Symbol ci4 = PORTA.5
; 25: 
; 26: //define feed-back
; 27: Symbol fb1 = PORTA.4
; 28: Symbol fb2 = PORTA.3
; 29: Symbol fb3 = PORTA.6
; 30: Symbol fb4 = PORTA.7
; 31: 
; 32: WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
	CALL W001
; 33: Call get_positions()
	CALL L0003
; 34: Main:
L0001:
; 35: //switch 1
; 36: ci1 = PORTA.0
; 37: If ci1 <> ap_1 Then
	CLRW
	BTFSC 0x005,0
	ADDLW 0x01
	BTFSC 0x026,0
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0006
; 38: ap_1 = ci1
	BCF 0x026,0
	BTFSC PORTA,0
	BSF 0x026,0
; 39: If ci1 = 1 Then  //*     switch straight
	BTFSS 0x005,0
	GOTO L0007
; 40: Call set_position(1) //switch = 1
	MOVLW 0x01
	MOVWF 0x027
	CALL L0002
; 41: Else  //*               switch round
	GOTO L0008
L0007:
; 42: Call set_position(2) //switch = 2
	MOVLW 0x02
	MOVWF 0x027
	CALL L0002
; 43: Endif
L0008:
; 44: fb1 = ap_1
	BTFSS 0x026,0
	BCF PORTA,4
	BTFSC 0x026,0
	BSF PORTA,4
; 45: Endif
L0006:
; 46: //switch 2
; 47: ci2 = PORTA.1
; 48: If ci2 <> ap_2 Then
	CLRW
	BTFSC 0x005,1
	ADDLW 0x01
	BTFSC 0x026,1
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0009
; 49: ap_2 = ci2
	BCF 0x026,1
	BTFSC PORTA,1
	BSF 0x026,1
; 50: If ci2 = 1 Then  //*     switch straight
	BTFSS 0x005,1
	GOTO L0010
; 51: Call set_position(3) //switch = 3
	MOVLW 0x03
	MOVWF 0x027
	CALL L0002
; 52: Else  //*               switch round
	GOTO L0011
L0010:
; 53: Call set_position(4) //switch = 4
	MOVLW 0x04
	MOVWF 0x027
	CALL L0002
; 54: Endif
L0011:
; 55: fb2 = ap_2
	BTFSS 0x026,1
	BCF PORTA,3
	BTFSC 0x026,1
	BSF PORTA,3
; 56: Endif
L0009:
; 57: //switch 3
; 58: ci3 = PORTA.2
; 59: If ci3 <> ap_3 Then
	CLRW
	BTFSC 0x005,2
	ADDLW 0x01
	BTFSC 0x026,2
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0012
; 60: ap_3 = ci3
	BCF 0x026,2
	BTFSC PORTA,2
	BSF 0x026,2
; 61: If ci3 = 1 Then  //*     switch straight
	BTFSS 0x005,2
	GOTO L0013
; 62: Call set_position(5) //switch = 5
	MOVLW 0x05
	MOVWF 0x027
	CALL L0002
; 63: Else  //*               switch round
	GOTO L0014
L0013:
; 64: Call set_position(6) //switch = 6
	MOVLW 0x06
	MOVWF 0x027
	CALL L0002
; 65: Endif
L0014:
; 66: fb3 = ap_3
	BTFSS 0x026,2
	BCF PORTA,6
	BTFSC 0x026,2
	BSF PORTA,6
; 67: Endif
L0012:
; 68: //switch 4
; 69: ci4 = PORTA.5
; 70: If ci4 <> ap_4 Then
	CLRW
	BTFSC 0x005,5
	ADDLW 0x01
	BTFSC 0x026,3
	SUBLW 0x01
	BTFSC STATUS,Z
	GOTO L0015
; 71: ap_4 = ci4
	BCF 0x026,3
	BTFSC PORTA,5
	BSF 0x026,3
; 72: If ci4 = 1 Then  //*     switch straight
	BTFSS 0x005,5
	GOTO L0016
; 73: Call set_position(7) //switch = 7
	MOVLW 0x07
	MOVWF 0x027
	CALL L0002
; 74: Else  //*               switch round
	GOTO L0017
L0016:
; 75: Call set_position(8) //switch = 8
	MOVLW 0x08
	MOVWF 0x027
	CALL L0002
; 76: Endif
L0017:
; 77: fb4 = ap_4
	BTFSS 0x026,3
	BCF PORTA,7
	BTFSC 0x026,3
	BSF PORTA,7
; 78: Endif
L0015:
; 79: 
; 80: Goto Main
	GOTO L0001
; 81: 
; 82: End
L0018:	GOTO L0018
; 83: 
; 84: Proc set_position(switch As Byte)
L0002:
; 85: // first get dip switch settings
; 86: dummy = 0
	CLRF 0x024
; 87: dummy.0 = PORTB.7
	BCF 0x024,0
	BTFSC PORTB,7
	BSF 0x024,0
; 88: dummy.1 = PORTB.6
	BCF 0x024,1
	BTFSC PORTB,6
	BSF 0x024,1
; 89: Select Case dummy
; 90: Case 3
	MOVLW 0x03
	SUBWF 0x024,W
	BTFSS STATUS,Z
	GOTO L0019
; 91: activation_time = 100
	MOVLW 0x64
	MOVWF 0x022
	CLRF 0x023
; 92: Case 2
	GOTO L0020
L0019:
	MOVLW 0x02
	SUBWF 0x024,W
	BTFSS STATUS,Z
	GOTO L0021
; 93: activation_time = 250
	MOVLW 0xFA
	MOVWF 0x022
	CLRF 0x023
; 94: Case 1
	GOTO L0022
L0021:
	MOVLW 0x01
	SUBWF 0x024,W
	BTFSS STATUS,Z
	GOTO L0023
; 95: activation_time = 500
	MOVLW 0xF4
	MOVWF 0x022
	MOVLW 0x01
	MOVWF 0x023
; 96: Case Else
	GOTO L0024
L0023:
; 97: activation_time = 2000
	MOVLW 0xD0
	MOVWF 0x022
	MOVLW 0x07
	MOVWF 0x023
; 98: EndSelect
L0024:
L0022:
L0020:
; 99: 
; 100: PORTB = LookUp(%11000011, %11000110, %11000101, %11001010, %11001001, %11010010, %11010001, %11100010, %11100001), switch
	MOVF 0x027,W
	MOVWF R0L
	SUBLW 0x08
	BTFSS STATUS,C
	GOTO L0025
	CALL _lookup_lab_0001
	MOVWF PORTB
L0025:
; 101: WaitMs activation_time
	MOVF 0x022,W
	MOVWF R0L
	MOVF 0x023,W
	MOVWF R0H
	CALL W001
; 102: PORTB = %11000011
	MOVLW 0xC3
	MOVWF PORTB
; 103: switch = 0
	CLRF 0x027
; 104: 
; 105: End Proc
	RETURN
; 106: 
; 107: Proc get_positions()
L0003:
; 108: ap_1 = PORTA.0
	BCF 0x026,0
	BTFSC PORTA,0
	BSF 0x026,0
; 109: fb1 = ap_1
	BTFSS 0x026,0
	BCF PORTA,4
	BTFSC 0x026,0
	BSF PORTA,4
; 110: ap_2 = PORTA.1
	BCF 0x026,1
	BTFSC PORTA,1
	BSF 0x026,1
; 111: fb2 = ap_2
	BTFSS 0x026,1
	BCF PORTA,3
	BTFSC 0x026,1
	BSF PORTA,3
; 112: ap_3 = PORTA.2
	BCF 0x026,2
	BTFSC PORTA,2
	BSF 0x026,2
; 113: fb3 = ap_3
	BTFSS 0x026,2
	BCF PORTA,6
	BTFSC 0x026,2
	BSF PORTA,6
; 114: ap_4 = PORTA.5
	BCF 0x026,3
	BTFSC PORTA,5
	BSF 0x026,3
; 115: fb4 = ap_4
	BTFSS 0x026,3
	BCF PORTA,7
	BTFSC 0x026,3
	BSF PORTA,7
; 116: End Proc
	RETURN
; 117: 
; 118: 
; Library code
L0004:
	RETURN
; End of user code
L0026:	GOTO L0026
;
;
; Delay Routine Byte
; minimal routine execution time: 8us
; routine execution time step: 3us
; maximal routine execution time: 770us
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 15us
; routine execution time step: 10us
; maximal routine execution time: 655365us
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0x61
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
;
;
;
;
; Configuration settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
