; Compiled with: PIC Simulator IDE v7.25
; Microcontroller model: PIC16F688
; Clock frequency: 8.0MHz
;
	R0L EQU 0x020
	R0H EQU 0x021
	R1L EQU 0x022
	R1H EQU 0x023
	R2L EQU 0x024
	R2H EQU 0x025
	R3L EQU 0x026
	R3H EQU 0x027
	R4L EQU 0x028
	R4H EQU 0x029
	R0HL EQU 0x020
	R1HL EQU 0x022
	R2HL EQU 0x024
	R3HL EQU 0x026
	R4HL EQU 0x028
	R1HL0HL EQU 0x020
	R3HL2HL EQU 0x024
;       The address of 'character' (byte) (global) is 0x02C
;       The address of 'character_count' (byte) (global) is 0x02A
;       The address of 'old_adress' (byte) (global) is 0x032
;       The address of 'new_adress' (byte) (global) is 0x033
;       The address of 'adress' (byte) (global) is 0x02E
;       The address of 'device_adress' (byte) (global) is 0x02F
;       The address of 'leds' (byte) (global) is 0x030
;       The address of 'command_type' (byte) (global) is 0x02B
;       The address of 'value' (byte) (set_leds) is 0x02D
;       The address of 'value' (byte) (convert_ascii) is 0x031
;       The address of 'led1' (bit) (global) is 0x007,2
;       The address of 'led2' (bit) (global) is 0x007,1
;       The address of 'led3' (bit) (global) is 0x007,0
;       The address of 'led4' (bit) (global) is 0x005,2
;       The address of 'led5' (bit) (global) is 0x005,1
;       The address of 'led6' (bit) (global) is 0x005,4
;       The address of 'led7' (bit) (global) is 0x005,0
;       The address of 'led8' (bit) (global) is 0x005,5
;       The address of 'led9' (bit) (global) is 0x007,3
	ORG 0x0000
	BCF PCLATH,4
	BCF PCLATH,3
	GOTO L0005
	ORG 0x0004
	RETFIE
; User code start
L0005:
; 1: 'Program for Serial Programming Leds 8 bit version
; 2: 'processor PIC16F688  4 MHz
; 3: Define CONFIG = 0x33c4
; 4: Define CLOCK_FREQUENCY = 8
; 5: AllDigital
	BSF STATUS,RP0
	CLRF ANSEL
	MOVLW 0x07
	BCF STATUS,RP0
	MOVWF CMCON0
; 6: TRISA = %001000
	MOVLW 0x08
	BSF STATUS,RP0
	MOVWF TRISA
	BCF STATUS,RP0
; 7: TRISC = %110000
	MOVLW 0x30
	BSF STATUS,RP0
	MOVWF TRISC
; 8: OSCCON.4 = 1
	BSF OSCCON,4
; 9: OSCCON.5 = 1
	BSF OSCCON,5
; 10: OSCCON.6 = 1
	BSF OSCCON,6
	BCF STATUS,RP0
; 11: Dim character As Byte
; 12: Dim character_count As Byte  'this byte stores which received character is to be handled
; 13: Dim old_adress As Byte
; 14: Dim new_adress As Byte
; 15: Dim adress As Byte  'adress to be matched with decie_address
; 16: Dim device_adress As Byte
; 17: Dim leds As Byte
; 18: Dim command_type As Byte
; 19: 
; 20: Symbol led1 = RC2
; 21: Symbol led2 = RC1
; 22: Symbol led3 = RC0
; 23: Symbol led4 = RA2
; 24: Symbol led5 = RA1
; 25: Symbol led6 = RA4
; 26: Symbol led7 = RA0
; 27: Symbol led8 = RA5
; 28: Symbol led9 = RC3
; 29: Hseropen 9600  'set serial receive to 9600 bd
; exact baud rate achieved = 9615.385; bit period = 104s; baud rate error = .16%
	MOVLW 0x0C
	MOVWF SPBRG
	CLRF BAUDCTL
	MOVLW 0x20
	MOVWF TXSTA
	MOVLW 0x90
	MOVWF RCSTA
; 30: led9 = 0
	BCF PORTC,3
; 31: WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
	CALL W001
; 32: character_count = 0
	CLRF 0x02A
; 33: 'Read 0, device_adress  'get the address of this chip
; 34: '********************************************
; 35: 'temporary, to be removed later on
; 36: 'If device_adress = 255 Then
; 37: device_adress = 2
	MOVLW 0x02
	MOVWF 0x02F
; 38: 'Write 0, device_adress
; 39: 'Endif
; 40: '********************************************
; 41: Call set_leds(device_adress)  'show programmed address
	MOVF 0x02F,W
	MOVWF 0x02D
	CALL L0002
; 42: 'waitms 2000
; 43: 'Call set_leds(0)  'leds remain on, until first message.
; 44: command_type = 0
	CLRF 0x02B
; 45: leds = 0
	CLRF 0x030
; 46: adress = 0
	CLRF 0x02E
; 47: 
; 48: main:
L0001:
; 49: led9 = 1  'led off
	BSF PORTC,3
; 50: Hserin character
	CALL HS10
	MOVWF 0x02C
; 51: 
; 52: character_count = character_count + 1
	MOVF 0x02A,W
	ADDLW 0x01
	MOVWF 0x02A
; 53: led9 = 0  'led on
	BCF PORTC,3
; 54: command_type = 0
	CLRF 0x02B
; 55: Select Case character_count
; 56: Case 1
	MOVF 0x02A,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0006
; 57: If character <> 72 Then  '*  'H' received?
	MOVF 0x02C,W
	SUBLW 0x48
	BTFSC STATUS,Z
	GOTO L0007
; 58: character_count = 0  'wrong character , start again
	CLRF 0x02A
; 59: Endif
L0007:
; 60: Case 2
	GOTO L0008
L0006:
	MOVF 0x02A,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0009
; 61: Call convert_ascii()
	CALL L0004
; 62: adress = character * 16
	MOVF 0x02C,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x02E
; 63: old_adress = adress
	MOVF 0x02E,W
	MOVWF 0x032
; 64: Case 3
	GOTO L0010
L0009:
	MOVF 0x02A,W
	SUBLW 0x03
	BTFSS STATUS,Z
	GOTO L0011
; 65: Call convert_ascii()
	CALL L0004
; 66: adress = old_adress Or character
	MOVF 0x032,W
	MOVWF R0L
	MOVF 0x02C,W
	IORWF R0L,W
	MOVWF 0x02E
; 67: old_adress = adress
	MOVF 0x02E,W
	MOVWF 0x032
; 68: Case 4
	GOTO L0012
L0011:
	MOVF 0x02A,W
	SUBLW 0x04
	BTFSS STATUS,Z
	GOTO L0013
; 69: If character = 83 Then  '*  'S'received
	MOVF 0x02C,W
	SUBLW 0x53
	BTFSS STATUS,Z
	GOTO L0014
; 70: command_type = 1
	MOVLW 0x01
	MOVWF 0x02B
; 71: Else
	GOTO L0015
L0014:
; 72: If character = 80 Then  '*  'P' received
	MOVF 0x02C,W
	SUBLW 0x50
	BTFSS STATUS,Z
	GOTO L0016
; 73: command_type = 2
	MOVLW 0x02
	MOVWF 0x02B
; 74: Else
	GOTO L0017
L0016:
; 75: character_count = 0  'BETTER START AGAIN
	CLRF 0x02A
; 76: Endif
L0017:
; 77: Endif
L0015:
; 78: Case 5
	GOTO L0018
L0013:
	MOVF 0x02A,W
	SUBLW 0x05
	BTFSS STATUS,Z
	GOTO L0019
; 79: Select Case command_type
; 80: Case 1
	MOVF 0x02B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0020
; 81: Call convert_ascii()
	CALL L0004
; 82: leds = character * 16
	MOVF 0x02C,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x030
; 83: Case 2
	GOTO L0021
L0020:
	MOVF 0x02B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0022
; 84: If character <> 97 Then  '*  'a'received?
	MOVF 0x02C,W
	SUBLW 0x61
	BTFSC STATUS,Z
	GOTO L0023
; 85: command_type = 0
	CLRF 0x02B
; 86: character_count = 0  'wrong character , start again
	CLRF 0x02A
; 87: Endif
L0023:
; 88: Case Else
	GOTO L0024
L0022:
; 89: EndSelect
L0024:
L0021:
; 90: Case 6
	GOTO L0025
L0019:
	MOVF 0x02A,W
	SUBLW 0x06
	BTFSS STATUS,Z
	GOTO L0026
; 91: Select Case command_type
; 92: Case 1
	MOVF 0x02B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0027
; 93: Call convert_ascii()
	CALL L0004
; 94: leds = leds Or character
	MOVF 0x030,W
	MOVWF R0L
	MOVF 0x02C,W
	IORWF R0L,W
	MOVWF 0x030
; 95: Case 2
	GOTO L0028
L0027:
	MOVF 0x02B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0029
; 96: If character <> 97 Then  '*  'a'received?
	MOVF 0x02C,W
	SUBLW 0x61
	BTFSC STATUS,Z
	GOTO L0030
; 97: command_type = 0
	CLRF 0x02B
; 98: character_count = 0  'wrong character , start again
	CLRF 0x02A
; 99: Endif
L0030:
; 100: Case Else
	GOTO L0031
L0029:
; 101: EndSelect
L0031:
L0028:
; 102: Case 7
	GOTO L0032
L0026:
	MOVF 0x02A,W
	SUBLW 0x07
	BTFSS STATUS,Z
	GOTO L0033
; 103: Select Case command_type
; 104: Case 1
	MOVF 0x02B,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0034
; 105: character_count = 0  'END OF TRANSMISSION
	CLRF 0x02A
; 106: If character = 13 Then  'only when CR received
	MOVF 0x02C,W
	SUBLW 0x0D
	BTFSS STATUS,Z
	GOTO L0035
; 107: If adress = device_adress Then
	MOVF 0x02E,W
	SUBWF 0x02F,W
	BTFSS STATUS,Z
	GOTO L0036
; 108: Call set_leds(leds)
	MOVF 0x030,W
	MOVWF 0x02D
	CALL L0002
; 109: Endif
L0036:
; 110: Endif
L0035:
; 111: Case 2
	GOTO L0037
L0034:
	MOVF 0x02B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0038
; 112: If character <> 53 Then  '*  '5'received?
	MOVF 0x02C,W
	SUBLW 0x35
	BTFSC STATUS,Z
	GOTO L0039
; 113: command_type = 0
	CLRF 0x02B
; 114: character_count = 0  'wrong character , start again
	CLRF 0x02A
; 115: Endif
L0039:
; 116: Case Else
	GOTO L0040
L0038:
; 117: EndSelect
L0040:
L0037:
; 118: Case 8
	GOTO L0041
L0033:
	MOVF 0x02A,W
	SUBLW 0x08
	BTFSS STATUS,Z
	GOTO L0042
; 119: If command_type = 2 Then
	MOVF 0x02B,W
	SUBLW 0x02
	BTFSS STATUS,Z
	GOTO L0043
; 120: If character <> 53 Then  '*  '5'received?
	MOVF 0x02C,W
	SUBLW 0x35
	BTFSC STATUS,Z
	GOTO L0044
; 121: command_type = 0
	CLRF 0x02B
; 122: character_count = 0  'wrong character , start again
	CLRF 0x02A
; 123: Endif
L0044:
; 124: Endif
L0043:
; 125: Case 9
	GOTO L0045
L0042:
	MOVF 0x02A,W
	SUBLW 0x09
	BTFSS STATUS,Z
	GOTO L0046
; 126: Call convert_ascii()
	CALL L0004
; 127: new_adress = character * 16
	MOVF 0x02C,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x10
	MOVWF R1L
	CLRF R1H
	CALL M001
	MOVF R2L,W
	MOVWF 0x033
; 128: Case 10
	GOTO L0047
L0046:
	MOVF 0x02A,W
	SUBLW 0x0A
	BTFSS STATUS,Z
	GOTO L0048
; 129: Call convert_ascii()
	CALL L0004
; 130: new_adress = new_adress Or character
	MOVF 0x033,W
	MOVWF R0L
	MOVF 0x02C,W
	IORWF R0L,W
	MOVWF 0x033
; 131: Case 11
	GOTO L0049
L0048:
	MOVF 0x02A,W
	SUBLW 0x0B
	BTFSS STATUS,Z
	GOTO L0050
; 132: character_count = 0
	CLRF 0x02A
; 133: If character = 13 Then
	MOVF 0x02C,W
	SUBLW 0x0D
	BTFSS STATUS,Z
	GOTO L0051
; 134: Gosub setadress
	CALL L0003
; 135: Endif
L0051:
; 136: Case Else
	GOTO L0052
L0050:
; 137: EndSelect
L0052:
L0049:
L0047:
L0045:
L0041:
L0032:
L0025:
L0018:
L0012:
L0010:
L0008:
; 138: 
; 139: Goto main
	GOTO L0001
; 140: End
L0053:	GOTO L0053
; 141: 
; 142: Proc set_leds(value As Byte)
L0002:
; 143: led1 = value.0
	BCF PORTC,2
	BTFSC 0x02D,0
	BSF PORTC,2
; 144: led2 = value.1
	BCF PORTC,1
	BTFSC 0x02D,1
	BSF PORTC,1
; 145: led3 = value.2
	BCF PORTC,0
	BTFSC 0x02D,2
	BSF PORTC,0
; 146: led4 = value.3
	BCF PORTA,2
	BTFSC 0x02D,3
	BSF PORTA,2
; 147: led5 = value.4
	BCF PORTA,1
	BTFSC 0x02D,4
	BSF PORTA,1
; 148: led6 = value.5
	BCF PORTA,4
	BTFSC 0x02D,5
	BSF PORTA,4
; 149: led7 = value.6
	BCF PORTA,0
	BTFSC 0x02D,6
	BSF PORTA,0
; 150: led8 = value.7
	BCF PORTA,5
	BTFSC 0x02D,7
	BSF PORTA,5
; 151: End Proc
	RETURN
; 152: 
; 153: setadress:
L0003:
; 154: If device_adress = old_adress Then
	MOVF 0x02F,W
	SUBWF 0x032,W
	BTFSS STATUS,Z
	GOTO L0054
; 155: Write 0, new_adress
	MOVLW 0x00
	BSF STATUS,RP0
	MOVWF EEADR
	BCF STATUS,RP0
	MOVF 0x033,W
	BSF STATUS,RP0
	MOVWF EEDATA
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
L0055:	BTFSC EECON1,WR
	GOTO L0055
	BCF EECON1,WREN
	BCF STATUS,RP0
	BCF PIR1,EEIF
; 156: device_adress = new_adress
	MOVF 0x033,W
	MOVWF 0x02F
; 157: Endif
L0054:
; 158: Return
	RETURN
; 159: 
; 160: Proc convert_ascii(value As Byte)  'convert ascii value to binairy
L0004:
; 161: If value > 57 Then
	MOVF 0x031,W
	SUBLW 0x39
	BTFSC STATUS,C
	GOTO L0056
; 162: value = value - 55  'A..F > 10..15'
	MOVLW 0x37
	SUBWF 0x031,W
	MOVWF 0x031
; 163: Else
	GOTO L0057
L0056:
; 164: value = value - 48  '0..9
	MOVLW 0x30
	SUBWF 0x031,W
	MOVWF 0x031
; 165: Endif
L0057:
; 166: End Proc
	RETURN
; 167: 
; End of user code
L0058:	GOTO L0058
;
;
; Delay Routine Byte
; minimal routine execution time: 4s
; routine execution time step: 1.5s
; maximal routine execution time: 385s
DL01:
	DECFSZ R4L,F
	GOTO DL01
	RETURN
; Delay Routine Word
; minimal routine execution time: 7.5s
; routine execution time step: 5s
; maximal routine execution time: 327682.5s
DL02:
	MOVLW 0x01
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO DL02
; Waitms Routine
W001:	MOVLW 0x01
	SUBWF R0L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R0H,F
	BTFSS STATUS,C
	RETURN
	MOVLW 0xC5
	MOVWF R4L
	MOVLW 0x00
	MOVWF R4H
	CALL DL02
	GOTO W001
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Hardware Serial Communication Routines
HS01:
	BTFSC PIR1,TXIF
	GOTO HS02
	GOTO HS01
HS02:	MOVWF TXREG
	RETURN
HS10:
	BTFSC PIR1,RCIF
	GOTO HS11
	GOTO HS10
HS11:	MOVF RCREG,W
	RETURN
;
;
; Configuration settings
	ORG 0x2007
	DW 0x33C4
; End of listing
	END
