; Compiled with: PIC Simulator IDE v6.90
; Microcontroller model: PIC16F628A
; Clock frequency: 9.0 MHz
;
;       The address of 'ir_count' (array 5) (byte) (global) is 0x2D
	ir_count EQU 0x2D
;       The address of 'fn1' (bit) (global) is 0x5,4
;       The address of 'fn2' (bit) (global) is 0x6,2
;       The address of 'fn3' (bit) (global) is 0x6,6
;       The address of 'fn4' (bit) (global) is 0x6,7
;       The address of 'irs1' (bit) (global) is 0x5,0
;       The address of 'irs2' (bit) (global) is 0x5,1
;       The address of 'irs3' (bit) (global) is 0x5,2
;       The address of 'irs4' (bit) (global) is 0x5,3
;       The address of 'switch1' (bit) (global) is 0x6,0
;       The address of 'switch2' (bit) (global) is 0x6,1
;       The address of 'switch3' (bit) (global) is 0x6,4
;       The address of 'switch4' (bit) (global) is 0x6,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ARRARG_0 EQU 0x2C
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0006
	ORG 0x0004
	RETFIE
; Begin of program
L0006:
; 1: Define CONF_WORD = 0x3f62
; 2: 
; 3: 
; 4: 'Program GCA133 Quadruple IR gate
; 5: 'Activated IRGate will be accepted within 10 mSec (output goes low).
; 6: 'switch off will take 0.5 - 2 seconds.(output goes high)
; 7: 
; 8: Symbol fn1 = RA4
; 9: Symbol fn2 = RB2
; 10: Symbol fn3 = RB6
; 11: Symbol fn4 = RB7
; 12: Symbol irs1 = RA0
; 13: Symbol irs2 = RA1
; 14: Symbol irs3 = RA2
; 15: Symbol irs4 = RA3
; 16: Symbol switch1 = RB0
; 17: Symbol switch2 = RB1
; 18: Symbol switch3 = RB4
; 19: Symbol switch4 = RB5
; 20: Dim ir_count(5) As Byte
; 21: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 22: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 23: TRISA = %001111
	MOVLW 0x0F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 24: TRISB = %00110011
	MOVLW 0x33
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 25: PORTA = 255
	MOVLW 0xFF
	MOVWF 0x05
; 26: PORTB = 255
	MOVLW 0xFF
	MOVWF 0x06
; 27: PWMon 1, 9  'set to 36 KHz output at RB3
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BCF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 28: PWMduty 1, 127
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x20
	MOVWF CCPR1L
; 29: loop:
L0001:
; 30: 
; 31: sensor_1:
L0002:
; 32: 	If irs1 = switch1 Then  'jumper dictates if input must be 1 or 0
	CLRW
	BTFSC 0x05,0
	ADDLW 0x01
	BTFSC 0x06,0
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0007
; 33: 		ir_count(1) = ir_count(1) + 1
	MOVF 0x2E,W
	ADDLW 0x01
	MOVWF 0x2E
; 34: 		If ir_count(1) > 1 Then  'to switch on, a minimum of 20 mS is needed , before reaction is there
	MOVF 0x2E,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0008
; 35: 			fn1 = 0  'output on
	BCF 0x05,4
; 36: 			ir_count(1) = 200
	MOVLW 0xC8
	MOVWF 0x2E
; 37: 		Endif
L0008:
; 38: 	Else
	GOTO L0009
L0007:
; 39: 		If ir_count(1) > 0 Then
	MOVF 0x2E,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0010
; 40: 			ir_count(1) = ir_count(1) - 1
	MOVLW 0x01
	SUBWF 0x2E,W
	MOVWF 0x2E
; 41: 		Else
	GOTO L0011
L0010:
; 42: 			fn1 = 1  'output off, if counted to zero
	BSF 0x05,4
; 43: 		Endif
L0011:
; 44: 	Endif
L0009:
; 45: 
; 46: sensor_2:
L0003:
; 47: 	If irs2 = switch2 Then  'jumper dictates if input must be 1 or 0
	CLRW
	BTFSC 0x05,1
	ADDLW 0x01
	BTFSC 0x06,1
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0012
; 48: 		ir_count(2) = ir_count(2) + 1
	MOVF 0x2F,W
	ADDLW 0x01
	MOVWF 0x2F
; 49: 		If ir_count(2) > 1 Then  'to switch on, a minimum of 20 mS is needed , before reaction is there
	MOVF 0x2F,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0013
; 50: 			fn2 = 0  'output on
	BCF 0x06,2
; 51: 			ir_count(2) = 200
	MOVLW 0xC8
	MOVWF 0x2F
; 52: 		Endif
L0013:
; 53: 	Else
	GOTO L0014
L0012:
; 54: 		If ir_count(2) > 0 Then
	MOVF 0x2F,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0015
; 55: 			ir_count(2) = ir_count(2) - 1
	MOVLW 0x01
	SUBWF 0x2F,W
	MOVWF 0x2F
; 56: 		Else
	GOTO L0016
L0015:
; 57: 			fn2 = 1  'output off, if counted to zero
	BSF 0x06,2
; 58: 		Endif
L0016:
; 59: 	Endif
L0014:
; 60: 
; 61: sensor_3:
L0004:
; 62: 	If irs3 = switch3 Then  'jumper dictates if input must be 1 or 0
	CLRW
	BTFSC 0x05,2
	ADDLW 0x01
	BTFSC 0x06,4
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0017
; 63: 		ir_count(3) = ir_count(3) + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 64: 		If ir_count(3) > 1 Then  'to switch on, a minimum of 20 mS is needed , before reaction is there
	MOVF 0x30,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0018
; 65: 			fn3 = 0  'output on
	BCF 0x06,6
; 66: 			ir_count(3) = 200
	MOVLW 0xC8
	MOVWF 0x30
; 67: 		Endif
L0018:
; 68: 	Else
	GOTO L0019
L0017:
; 69: 		If ir_count(3) > 0 Then
	MOVF 0x30,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0020
; 70: 			ir_count(3) = ir_count(3) - 1
	MOVLW 0x01
	SUBWF 0x30,W
	MOVWF 0x30
; 71: 		Else
	GOTO L0021
L0020:
; 72: 			fn3 = 1  'output off, if counted to zero
	BSF 0x06,6
; 73: 		Endif
L0021:
; 74: 	Endif
L0019:
; 75: 
; 76: sensor_4:
L0005:
; 77: 	If irs4 = switch4 Then  'jumper dictates if input must be 1 or 0
	CLRW
	BTFSC 0x05,3
	ADDLW 0x01
	BTFSC 0x06,5
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0022
; 78: 		ir_count(4) = ir_count(4) + 1
	MOVF 0x31,W
	ADDLW 0x01
	MOVWF 0x31
; 79: 		If ir_count(4) > 1 Then  'to switch on, a minimum of 20 mS is needed , before reaction is there
	MOVF 0x31,W
	SUBLW 0x01
	BTFSC STATUS,C
	GOTO L0023
; 80: 			fn4 = 0  'output on
	BCF 0x06,7
; 81: 			ir_count(4) = 200
	MOVLW 0xC8
	MOVWF 0x31
; 82: 		Endif
L0023:
; 83: 	Else
	GOTO L0024
L0022:
; 84: 		If ir_count(4) > 0 Then
	MOVF 0x31,W
	SUBLW 0x00
	BTFSC STATUS,C
	GOTO L0025
; 85: 			ir_count(4) = ir_count(4) - 1
	MOVLW 0x01
	SUBWF 0x31,W
	MOVWF 0x31
; 86: 		Else
	GOTO L0026
L0025:
; 87: 			fn4 = 1  'output off, if counted to zero
	BSF 0x06,7
; 88: 		Endif
L0026:
; 89: 	Endif
L0024:
; 90: 
; 91: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
	CALL W001
; 92: Goto loop
	GOTO L0001
; 93: End
L0027:	GOTO L0027
; End of program
L0028:	GOTO L0028
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x2B
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F62
; End of listing
	END
