	list p=16f628
	#include <p16f628.inc>
	radix dec
; Compiled with: PIC Simulator IDE v6.71
; Microcontroller model: PIC16F628
; Clock frequency: 4.0 MHz
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,4
	GOTO L0002
	ORG 0x0004
	RETFIE
L0002:
; 1:  'program servo motoron
; 2:  'print MGV81
; 3:  'bedoeld voor het besturen van 4 servomotoren voor wissels
; 4: Define CONF_WORD = 0x3f50
; 5: 
; 6: AllDigital
	MOVLW 0x07
	MOVWF 0x1F
; 7: CMCON = 7
	MOVLW 0x07
	MOVWF 0x1F
; 8: TRISA = %00011001
	BSF STATUS,RP0
	MOVLW 0x19
	MOVWF 0x05
; 9: TRISB = %00000000
	CLRF 0x06
; 10: PORTA = 0
	BCF STATUS,RP0
	CLRF 0x05
; 11: PORTB = 0
	CLRF 0x06
; 12: 
; 13: Symbol fwd = PORTB.4
;       The address of 'fwd' is 0x6,4
; 14: Symbol rev = PORTB.5
;       The address of 'rev' is 0x6,5
; 15: Symbol red_led = PORTB.6
;       The address of 'red_led' is 0x6,6
; 16: Symbol green_led = PORTB.7
;       The address of 'green_led' is 0x6,7
; 17: Symbol command = PORTA.0
;       The address of 'command' is 0x5,0
; 18: Symbol fbup = PORTA.1
;       The address of 'fbup' is 0x5,1
; 19: Symbol fbdn = PORTA.2
;       The address of 'fbdn' is 0x5,2
; 20: Symbol limit_up = PORTA.3
;       The address of 'limit_up' is 0x5,3
; 21: Symbol limit_dn = PORTA.4
;       The address of 'limit_dn' is 0x5,4
; 22: Symbol redsign = PORTA.5
;       The address of 'redsign' is 0x5,5
; 23: Symbol yellowsign = PORTA.6
;       The address of 'yellowsign' is 0x5,6
; 24: Symbol greensign = PORTA.7
;       The address of 'greensign' is 0x5,7
; 25: Dim direction As Byte
;       The address of 'direction' is 0x2C
	direction EQU 0x2C
; 26: PWMon 1, 1
	MOVLW 0xFF
	BSF STATUS,RP0
	MOVWF PR2
	BCF TRISB,3
	BCF STATUS,RP0
	CLRF CCPR1L
	BCF CCP1CON,CCP1X
	BCF CCP1CON,CCP1Y
	BCF T2CON,T2CKPS0
	BSF T2CON,T2CKPS1
	BSF T2CON,TMR2ON
	MOVLW 0x0C
	IORWF CCP1CON,F
; 27: PWMduty 1, 400 'speed of motor ,  can be between 1 and 1023
	BSF CCP1CON,CCP1Y
	BSF CCP1CON,CCP1X
	MOVLW 0x64
	MOVWF CCPR1L
; 28: 
; 29: main: 
L0001:
; 30: If command = 0 Then
	BTFSC 0x05,0
	GOTO L0003
; 31: direction = 1
	MOVLW 0x01
	MOVWF 0x2C
; 32: Else
	GOTO L0004
L0003:	MOVLW 0x1F
	ANDWF STATUS,F
; 33: direction = 0
	CLRF 0x2C
; 34: Endif
L0004:	MOVLW 0x1F
	ANDWF STATUS,F
; 35: Select Case direction
; 36: Case 1 'bridge should be up
	MOVF 0x2C,W
	SUBLW 0x01
	BTFSS STATUS,Z
	GOTO L0005
; 37: red_led = 1
	BSF 0x06,6
; 38: green_led = 0
	BCF 0x06,7
; 39: If limit_up = 0 Then 'bridge is upper most position
	BTFSC 0x05,3
	GOTO L0006
; 40: fwd = 0 'stop the motor
	BCF 0x06,4
; 41: rev = 0
	BCF 0x06,5
; 42: fbup = 0
	BCF 0x05,1
; 43: fbdn = 1
	BSF 0x05,2
; 44: redsign = 0
	BCF 0x05,5
; 45: yellowsign = 0
	BCF 0x05,6
; 46: greensign = 1
	BSF 0x05,7
; 47: Else
	GOTO L0007
L0006:	MOVLW 0x1F
	ANDWF STATUS,F
; 48: fbup = 1
	BSF 0x05,1
; 49: fbdn = 1
	BSF 0x05,2
; 50: fwd = 1 'run forward
	BSF 0x06,4
; 51: rev = 0
	BCF 0x06,5
; 52: redsign = 1
	BSF 0x05,5
; 53: yellowsign = 1
	BSF 0x05,6
; 54: greensign = 0
	BCF 0x05,7
; 55: Endif
L0007:	MOVLW 0x1F
	ANDWF STATUS,F
; 56: Case Else 'bridge must be in down position
	GOTO L0008
L0005:	MOVLW 0x1F
	ANDWF STATUS,F
; 57: red_led = 0
	BCF 0x06,6
; 58: green_led = 1
	BSF 0x06,7
; 59: redsign = 1
	BSF 0x05,5
; 60: yellowsign = 1
	BSF 0x05,6
; 61: greensign = 0
	BCF 0x05,7
; 62: If limit_dn = 0 Then 'bridge is lower most position
	BTFSC 0x05,4
	GOTO L0009
; 63: fbup = 1
	BSF 0x05,1
; 64: fbdn = 0
	BCF 0x05,2
; 65: fwd = 0 'stop the motor
	BCF 0x06,4
; 66: rev = 0
	BCF 0x06,5
; 67: fbup = 0
	BCF 0x05,1
; 68: fbdn = 1
	BSF 0x05,2
; 69: Else
	GOTO L0010
L0009:	MOVLW 0x1F
	ANDWF STATUS,F
; 70: fbup = 1
	BSF 0x05,1
; 71: fbdn = 1
	BSF 0x05,2
; 72: fwd = 0 'run backward
	BCF 0x06,4
; 73: rev = 1
	BSF 0x06,5
; 74: Endif
L0010:	MOVLW 0x1F
	ANDWF STATUS,F
; 75: EndSelect
L0008:	MOVLW 0x1F
	ANDWF STATUS,F
; 76: WaitMs 50 'there is no hurry
	MOVLW 0x32
	MOVWF R0L
	CLRF R0H
	CALL W001
; 77: 
; 78: Goto main
	GOTO L0001
; 79: End
L0011:	GOTO L0011
; End of program
L0012:	GOTO L0012
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x12
	MOVWF R1L
W005:	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Configuration word settings
	ORG 0x2007
	DW 0x3F50
; End of listing
	END
