Define CONF_WORD = 0x3f72


'Program MGV119 for PC-board MGV119
'Design by P.H.Giling
'This unit display time and ambient temperature by means of MGV118 mini led displays.
'the interval is set to 3 seconds

ADCON1 = %0110
Symbol sda = PORTC.4
Symbol scl = PORTC.3
Symbol col0 = PORTC.0
Symbol col1 = PORTC.1
Symbol col2 = PORTC.2
Symbol col3 = PORTC.5
Dim dis0 As Byte
Dim dis1 As Byte
Dim dis2 As Byte
Dim dis3 As Byte
Dim temp0 As Byte
Dim temp1 As Byte
Dim temperature As Byte
Dim hour As Byte
Dim minute As Byte
Dim which_digit As Byte
Dim teller As Byte
Dim value As Byte
Dim addr As Byte
Dim disp_count As Word
Dim disp As Byte
Dim var1 As Byte
Dim var2 As Byte
Dim key_delay As Byte
main:
	TRISA = %011100
	TRISB = %00000000
	TRISC = %00000000
	PORTA = %011100
	PORTB = 0
	PORTC = 0
	I2CPrepare sda, scl
	disp_count = 0
	Read 0, value
	If value = 255 Then          'chip running first time
		Write 0, 0
		Gosub init_clock
		Gosub init_temperature
		I2CWrite sda, scl, addr, 0xaa, 2          'init temperature
	WaitMs 10

	Endif
	Gosub init_temperature
	WaitMs 1000
	Gosub read_temperature
	Gosub read_clock
	loop:
		var1 = PORTA
'key positions
'PORTA    result
'28  no key pressed
'24  h/m key is pressed
'12 plus key only (minutes increas)
'20 minus key pressed (minutes decrease)
'16 minus key and h/m ley (decrease hours)
'8 plus key and h/m key pressed (increase hours)
		Select Case var1
		Case 8
			If key_delay = 0 Then
				disp_count = 1
				hour = hour + 1
				If hour > 23 Then
					hour = 0
				Endif
				Gosub write_clock
			Endif
		Case 16
			If key_delay = 0 Then
				disp_count = 1
				If hour > 0 Then
					hour = hour - 1
				Else
					hour = 23
				Endif
				Gosub write_clock
			Endif
		Case 12
			If key_delay = 0 Then
				disp_count = 1
				minute = minute + 1
				If minute > 59 Then
					minute = 0
				Endif
				Gosub write_clock
			Endif
		Case 20
			If key_delay = 0 Then
				disp_count = 1
				If minute > 0 Then
					minute = minute - 1
				Else
					minute = 59
				Endif
				Gosub write_clock
			Endif
		Case Else

		EndSelect
		key_delay = key_delay + 1          'this is ment to create a repeater for key
		If key_delay = 60 Then
			key_delay = 0
		Endif
		disp_count = disp_count + 1
		If disp_count > 1200 Then          'temp and time are read every 6 secs.
			disp_count = 0
			Gosub read_temperature
			Gosub read_clock
		Endif
		If disp_count < 600 Then
			Gosub display_time
		Else
			Gosub display_temperature
		Endif
		WaitMs 5
	Goto loop
End                                               
display_temperature:

	PORTC = %00011000
	which_digit = which_digit + 1
	If which_digit > 3 Then
		which_digit = 0
	Endif          'D            0                1                    2                   3                     4                    5                   6                     7                 8                  9                                        C
	Select Case which_digit
	Case 0
		If temp0 > 0 Then
			PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111, %01101111, %01100011, %00111001), temp0
		Else
			PORTB = 0
		Endif
		PORTC = %00011001
	Case 1
		PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111, %01100011, %00111001), temp1
		PORTC = %00011010
	Case 2
		PORTB = %01100011          'THIS IS THE DEGREE SIGN
		PORTC = %00011100
	Case Else
		PORTB = %00111001          'Capital 'C'
		PORTC = %00111000
	EndSelect
Return                                            

read_temperature:
	I2CStart
	I2CSend 0x90
	I2CSend 0xee
	I2CStop
	WaitMs 10
	I2CStart
	I2CSend 0x90
	I2CSend 0xaa
	I2CStop
	I2CStart
	I2CSend 0x91
	I2CRecA temperature
	I2CRecN temp0
	I2CStop
	If temperature > 99 Then
		temperature = 99
	Endif
	If temperature = 0 Then
		temperature = 24
	Endif
	temp0 = temperature / 10
	temp1 = temperature Mod 10
Return                                            


display_time:
	dis0 = hour / 10
	dis1 = hour Mod 10
	dis2 = minute / 10
	dis3 = minute Mod 10
	PORTC = %00011000
	which_digit = which_digit + 1
	If which_digit > 3 Then
		which_digit = 0
	Endif
	Select Case which_digit
	Case 0
		If dis0 > 0 Then
			PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111), dis0
		Else
			PORTB = 0
		Endif
		PORTC = %00011001
	Case 1
		PORTB = LookUp(%10111111, %10000110, %11011011, %11001111, %11100110, %11101101, %11111101, %10000111, %11111111, %11101111), dis1
		PORTC = %00011010
	Case 2
		PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111), dis2
		PORTC = %00011100
	Case Else
		PORTB = LookUp(%00111111, %00000110, %01011011, %01001111, %01100110, %01101101, %01111101, %00000111, %01111111, %01101111), dis3
		PORTC = %00111000
	EndSelect
Return                                            

read_clock:
	addr = 3
	I2CRead sda, scl, 0xa0, addr, minute
	var1 = minute
	var1 = var1 And 15
	var2 = minute
	var2 = var2 And 112
	var2 = var2 / 16
	var2 = var2 * 10
	minute = var1 + var2
	addr = 4
	I2CRead sda, scl, 0xa0, addr, hour
	var1 = hour
	var1 = var1 And 15
	var2 = hour
	var2 = var2 And 48
	var2 = var2 / 16
	var2 = var2 * 10
	hour = var1 + var2

Return                                            

write_clock:

	var1 = hour
	var1 = var1 Mod 10
	var2 = hour
	var2 = var2 / 10
	var2 = var2 * 16
	value = var1 + var2
	addr = 4
	I2CWrite sda, scl, 0xa0, addr, value
	var1 = minute
	var1 = var1 Mod 10
	var2 = minute
	var2 = var2 / 10
	var2 = var2 * 16
	value = var1 + var2
	addr = 3
	I2CWrite sda, scl, 0xa0, addr, value
Return                                            

init_temperature:
'addr = 0x90
'I2CStart
	
'I2CWrite sda, scl, addr, 0xac, 2
Return                                            

init_clock:
	addr = 0
	I2CWrite sda, scl, 0xa0, addr, %00001000


Return                                            

