'program for controlling 4 servos on railroad crossing (german type)
'Yellow lighst are connected to pin 7 and 8 of J6
'red lighst are connected  to pin 9 and 10 of J6
'servos  for right barriers (traffic direction!) are to be connected to J1 and J2
'servos  for left barriers (traffic direction!) are to be connected to J3 and J4
'in case MGV136 is used without MGV50:
'a supply of 5 volt needs to be connected to Pin1(plus 5V) and pin2 (minus 5Volt) of J6
'leds are To be connected between pin1 (anode) and pin 7,8,9 or 10 (kathode) of J6.
Define CONF_WORD = 0x3f50
AllDigital
TRISB = %00000001
TRISA = %11110000
Dim servo(3) As Byte
Const barrier_pos_up = 200
Const barrier_pos_down = 100
Dim dummy As Byte
Dim counter As Byte
Dim action As Byte
Dim claim As Byte
Const barrier_down = 1
Const barrier_up = 0
Symbol red1 = RA2
Symbol red2 = RA3
Symbol yel1 = RA0
Symbol yel2 = RA1


For counter = 1 To 2
	Read counter, servo(counter)
	If servo(counter) > 200 Then
		servo(counter) = 200
	Endif
	If servo(counter) = barrier_pos_up Then
		action(counter) = barrier_up
	Else
		action(counter) = barrier_down
	Endif

Next counter
dummy = 1
claim = 0
WaitMs 3000  'long wait to give MGV50 time for correct startup

'--------------------------- PROGRAM Mainloop ---------------------------
While dummy = 1  'endless loop
	If claim > 0 Then  'barrier 1 going down
		If action <> barrier_down Then
			servo(1) = barrier_pos_up
			servo(2) = barrier_pos_up
			yel1 = 1  'first the orange led #1 for 2 seconds
			yel2 = 1  'first the orange led #2 for 2 seconds
			WaitMs 2000
			red1 = 1  'now the red light #1 is on
			red2 = 1  'now the red light #2 is on
			yel1 = 0  'orange light off
			yel2 = 0  'orange light off
			WaitMs 5000  'wait 5 seconds
			While servo(1) > barrier_pos_down  'first the right barriers
				ServoOut RB4, servo(1)  'so needs to be run twice to get right speed.
				ServoOut RB5, servo(1)
				WaitMs 9
				Call check_inputs()
				ServoOut RB4, servo(1)  'so needs to be run twice to get right speed.
				ServoOut RB5, servo(1)
				WaitMs 9
				Call check_inputs()
				servo(1) = servo(1) - 1
			Wend
			While servo(2) > barrier_pos_down  'now left barriers
				ServoOut RB6, servo(2)  'so needs to be run twice to get right speed.
				ServoOut RB7, servo(2)
				WaitMs 9
				Call check_inputs()
				ServoOut RB6, servo(2)  'so needs to be run twice to get right speed.
				ServoOut RB7, servo(2)
				WaitMs 9
				Call check_inputs()
				servo(2) = servo(2) - 1
			Wend
			action = barrier_down
			Write 1, barrier_pos_down
			Write 2, barrier_pos_down
		Endif
	Else  'barrier going up
		If action <> barrier_up Then
			servo(1) = barrier_pos_down
			servo(2) = barrier_pos_down
			While servo(1) < barrier_pos_up  'first the right barriers
				ServoOut RB4, servo(1)  'so needs to be run twice to get right speed.
				ServoOut RB5, servo(1)
				ServoOut RB6, servo(1)  'so needs to be run twice to get right speed.
				ServoOut RB7, servo(1)
				WaitMs 8
				Call check_inputs()
				ServoOut RB4, servo(1)  'so needs to be run twice to get right speed.
				ServoOut RB5, servo(1)
				ServoOut RB6, servo(1)  'so needs to be run twice to get right speed.
				ServoOut RB7, servo(1)
				WaitMs 8
				Call check_inputs()
				servo(1) = servo(1) + 1
				servo(2) = servo(2) + 1
			Wend
			action = barrier_up
			Write 1, barrier_pos_up
			Write 2, barrier_pos_up
			counter = 0
			While counter < 100
				counter = counter + 1
				Call check_inputs()
				If claim > 0 Then
					counter = 101
				Endif
				WaitMs 10
				If counter = 100 Then  'skip this when claim has been set again
					red1 = 0  'now the red light off
					red2 = 0
				Endif
			Wend
		Endif
	Endif

Wend
End                                               
Proc check_inputs()
	If RA4 = 0 Then  '1st input asks for barrier down
		claim.0 = 1
	Endif
	If RA6 = 0 Then
		claim.0 = 0  '3rd input asks for barrier up
	Endif
	If RA7 = 0 Then  '2nd input asks for barrier down
		claim.1 = 1
	Endif
	If RB0 = 0 Then
		claim.1 = 0  '4th input asks for barrier up
	Endif
End Proc                                          