; Compiled with: PIC Simulator IDE v6.91
; Microcontroller model: PIC16F873A
; Clock frequency: 20.0 MHz
;
;       The value of 'disp1' (global) is 64
;       The value of 'disp2' (global) is 66
;       The value of 'mem_turn_counter' (global) is 101
;       The value of 'mem_act_pos' (global) is 102
;       The value of 'mem_speed_min' (global) is 103
;       The value of 'mem_speed_max' (global) is 104
;       The value of 'mem_speed_step' (global) is 105
;       The value of 'mem_one_round_lb' (global) is 106
;       The value of 'mem_one_round_hb' (global) is 107
;       The value of 'mem_ctrl_type' (global) is 108
;       The value of 'mem_max_pos' (global) is 109
;       The value of 'mem_free_space' (global) is 110
;       The value of 'mem_bridge_power' (global) is 112
;       The value of 'mem_bridge_switch1' (global) is 113
;       The value of 'mem_bridge_switch2' (global) is 114
;       The value of 'mem_bridge_switch3' (global) is 115
;       The value of 'mem_bridge_switch4' (global) is 116
;       The value of 'mem_bridge_switch5' (global) is 117
;       The value of 'mem_bridge_switch6' (global) is 118
;       The address of 'value' (byte) (global) is 0x30
	value EQU 0x30
;       The address of 'act_pos' (byte) (global) is 0x31
	act_pos EQU 0x31
;       The address of 'ctrl_type' (byte) (global) is 0x32
	ctrl_type EQU 0x32
;       The address of 'max_pos' (byte) (global) is 0x33
	max_pos EQU 0x33
;       The address of 'steps' (word) (global) is 0x34
	steps EQU 0x34
;       The address of 'new_steps' (word) (global) is 0x36
	new_steps EQU 0x36
;       The address of 'speed_max' (word) (global) is 0x38
	speed_max EQU 0x38
;       The address of 'manual_pos' (byte) (global) is 0x3A
	manual_pos EQU 0x3A
;       The address of 'bridge_switch' (bit) (global) is 0x3B,0
;       The address of 'value2' (byte) (global) is 0x3C
	value2 EQU 0x3C
;       The address of 'speed_min' (word) (global) is 0x3D
	speed_min EQU 0x3D
;       The address of 'result' (byte) (global) is 0x3F
	result EQU 0x3F
;       The address of 'one_round' (word) (global) is 0x40
	one_round EQU 0x40
;       The address of 'turn_counter' (byte) (global) is 0x42
	turn_counter EQU 0x42
;       The address of 'program_set' (byte) (global) is 0x43
	program_set EQU 0x43
;       The address of 'free_space_steps' (byte) (global) is 0x44
	free_space_steps EQU 0x44
;       The address of 'act_steps' (word) (global) is 0x45
	act_steps EQU 0x45
;       The address of 'speed_step' (byte) (global) is 0x47
	speed_step EQU 0x47
;       The address of 'new_pos' (byte) (global) is 0x48
	new_pos EQU 0x48
;       The address of 'speed' (word) (global) is 0x49
	speed EQU 0x49
;       The address of 'steps_set' (bit) (global) is 0x3B,1
;       The address of 'bus_pos' (byte) (global) is 0x4B
	bus_pos EQU 0x4B
;       The address of 'disp1_val' (byte) (global) is 0x4C
	disp1_val EQU 0x4C
;       The address of 'bridge_power' (bit) (global) is 0x3B,2
;       The address of 'new_encoder' (byte) (global) is 0x4D
	new_encoder EQU 0x4D
;       The address of 'encoder_count' (byte) (global) is 0x4E
	encoder_count EQU 0x4E
;       The address of 'disp2_val' (byte) (global) is 0x4F
	disp2_val EQU 0x4F
;       The address of 'use_zero_detector' (bit) (global) is 0x3B,3
;       The address of 'eprom_pointer' (byte) (global) is 0x50
	eprom_pointer EQU 0x50
;       The address of 'old_encoder' (byte) (global) is 0x51
	old_encoder EQU 0x51
;       The address of 'old_manual_pos' (byte) (global) is 0x52
	old_manual_pos EQU 0x52
;       The address of 'ramp_up' (bit) (global) is 0x3B,4
;       The address of 'version' (bit) (global) is 0x3B,5
;       The address of 'ramp_down_point' (word) (global) is 0x53
	ramp_down_point EQU 0x53
;       The address of 'one_round_half' (word) (global) is 0x55
	one_round_half EQU 0x55
;       The address of 'old_bus_pos' (byte) (global) is 0x57
	old_bus_pos EQU 0x57
;       The address of 'old_bridge_switch' (bit) (global) is 0x3B,6
;       The address of 'old_pos_write' (bit) (global) is 0x3B,7
;       The address of 'free_space_word' (word) (global) is 0x58
	free_space_word EQU 0x58
;       The address of 'half_steps' (word) (global) is 0x5A
	half_steps EQU 0x5A
;       The address of 'swfw' (bit) (global) is 0x6,0
;       The address of 'swrev' (bit) (global) is 0x6,1
;       The address of 'sck' (bit) (global) is 0x6,2
;       The address of 'sda' (bit) (global) is 0x6,3
;       The address of 'pos_match' (bit) (global) is 0x6,4
;       The address of 'pos_write' (bit) (global) is 0x6,5
;       The address of 'eep' (bit) (global) is 0x6,6
;       The address of 'max_end' (bit) (global) is 0x6,7
;       The address of 'direction' (bit) (global) is 0x7,0
;       The address of 'clk' (bit) (global) is 0x7,1
;       The address of 'ena' (bit) (global) is 0x7,2
;       The address of 'zero' (bit) (global) is 0x7,3
;       The address of 'ec1' (bit) (global) is 0x7,4
;       The address of 'ec2' (bit) (global) is 0x7,5
;       The address of 'ecsw' (bit) (global) is 0x7,6
;       The address of 'pgm' (bit) (global) is 0x7,7
;       The address of 'fy_stop' (bit) (global) is 0x5,5
; Begin
	R0L EQU 0x20
	R0H EQU 0x21
	R1L EQU 0x22
	R1H EQU 0x23
	R2L EQU 0x24
	R2H EQU 0x25
	R3L EQU 0x26
	R3H EQU 0x27
	R4L EQU 0x28
	R4H EQU 0x29
	R5L EQU 0x2A
	R5H EQU 0x2B
	SCL_PORT EQU 0x2C
	SCL_BIT EQU 0x2D
	SDA_PORT EQU 0x2E
	SDA_BIT EQU 0x2F
	ORG 0x0000
	BCF PCLATH,3
	BCF PCLATH,3
	GOTO L0017
	ORG 0x0004
	RETFIE
; LookUp Table: (3, 2, 1, 3)
_lookup_lab_0001:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x02
	RETLW 0x01
	RETLW 0x03
; LookUp Table: (1, 3, 3, 2)
_lookup_lab_0002:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x01
	RETLW 0x03
	RETLW 0x03
	RETLW 0x02
; LookUp Table: (2, 3, 3, 1)
_lookup_lab_0003:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x02
	RETLW 0x03
	RETLW 0x03
	RETLW 0x01
; LookUp Table: (3, 1, 2, 3)
_lookup_lab_0004:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0x03
	RETLW 0x01
	RETLW 0x02
	RETLW 0x03
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0005:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; LookUp Table: (%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111)
_lookup_lab_0006:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xFF
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
	RETLW 0xBF
; LookUp Table: (%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000)
_lookup_lab_0007:
	CLRF PCLATH
	MOVF R0L,W
	ADDWF PCL,F
	RETLW 0xC0
	RETLW 0xF9
	RETLW 0xA4
	RETLW 0xB0
	RETLW 0x99
	RETLW 0x92
	RETLW 0x82
	RETLW 0xF8
	RETLW 0x80
	RETLW 0x90
; Waitms Routine
W001:	MOVF R0L,F
	BTFSC STATUS,Z
	GOTO W002
	CALL W003
	DECF R0L,F
	NOP
	NOP
	NOP
	NOP
	NOP
	GOTO W001
W002:	MOVF R0H,F
	BTFSC STATUS,Z
	RETURN
	CALL W003
	DECF R0H,F
	DECF R0L,F
	GOTO W001
W003:	MOVLW 0x0C
	MOVWF R2H
W004:
	DECFSZ R2H,F
	GOTO W004
	NOP
	NOP
	MOVLW 0x62
	MOVWF R1L
W005:
	DECFSZ R1L,F
	GOTO W006
	CALL W007
	CALL W007
	NOP
	NOP
	RETURN
W006:
	CALL W007
	GOTO W005
W007:	MOVLW 0x0D
	MOVWF R2L
W008:
	DECFSZ R2L,F
	GOTO W008
	NOP
	RETURN
; Waitus Routine Byte
X001:	MOVLW 0x02
	SUBWF R4L,F
	BTFSS STATUS,C
	RETURN
	GOTO X002
X002:	MOVLW 0x02
	SUBWF R4L,F
	NOP
	NOP
	NOP
	NOP
	BTFSS STATUS,C
	RETURN
	GOTO X002
; Waitus Routine Word
Y001:	MOVLW 0x04
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
Y002:	MOVLW 0x02
	SUBWF R4L,F
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF R4H,F
	BTFSS STATUS,C
	RETURN
	GOTO Y002
; Word Multiplication Routine
M001:	MOVLW 0x10
	MOVWF R4L
	CLRF R0H
	CLRF R0L
M002:	RRF R3H,F
	RRF R3L,F
	BTFSS STATUS,C
	GOTO M003
	MOVF R1L,W
	ADDWF R0L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R0H,F
M003:	RRF R0H,F
	RRF R0L,F
	RRF R2H,F
	RRF R2L,F
	DECFSZ R4L,F
	GOTO M002
	RETURN
; Word Division Routine
D001:	MOVLW 0x10
	MOVWF R3L
	CLRF R2H
	CLRF R2L
D002:	RLF R0H,W
	RLF R2L,F
	RLF R2H,F
	MOVF R1L,W
	SUBWF R2L,F
	MOVF R1H,W
	BTFSS STATUS,C
	INCFSZ R1H,W
	SUBWF R2H,F
	BTFSC STATUS,C
	GOTO D003
	MOVF R1L,W
	ADDWF R2L,F
	MOVF R1H,W
	BTFSC STATUS,C
	INCFSZ R1H,W
	ADDWF R2H,F
	BCF STATUS,C
D003:	RLF R0L,F
	RLF R0H,F
	DECFSZ R3L,F
	GOTO D002
	RETURN
; Word Comparison Routine
C001:	MOVLW 0x05
	GOTO C007
C002:	MOVLW 0x02
	GOTO C007
C003:	MOVLW 0x06
	GOTO C007
C004:	MOVLW 0x03
	GOTO C007
C005:	MOVLW 0x04
	GOTO C007
C006:	MOVLW 0x01
C007:	MOVWF R4L
	MOVF R1H,W
	SUBWF R0H,W
	BTFSS STATUS,Z
	GOTO C008
	MOVF R1L,W
	SUBWF R0L,W
C008:	MOVLW 0x04
	BTFSC STATUS,C
	MOVLW 0x01
	BTFSC STATUS,Z
	MOVLW 0x02
	ANDWF R4L,W
	BTFSS STATUS,Z
	MOVLW 0xFF
	RETURN
; I2CWrite Routine
IC01:	MOVWF R0L
	MOVLW 0x08
	MOVWF R0H
IC02:	RLF R0L,F
	BTFSC STATUS,C
	CALL IC20
	BTFSS STATUS,C
	CALL IC21
	CALL IC22
	CALL IC23
	DECFSZ R0H,F
	GOTO IC02
	CALL IC24
	CALL IC03
	CALL IC25
	CALL IC21
	RETURN
IC03:
	CALL IC22
	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	ANDWF INDF,W
	ADDLW 0xFF
	CALL IC23
	RETURN
IC31:
	CALL IC21
	CALL IC23
	GOTO IC29
IC41:
	CALL IC22
	CALL IC20
	GOTO IC29
IC20:	MOVF SDA_PORT,W
	MOVWF FSR
	MOVF SDA_BIT,W
	IORWF INDF,F
	GOTO IC28
IC21:	MOVF SDA_PORT,W
	MOVWF FSR
	COMF SDA_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC22:	MOVF SCL_PORT,W
	MOVWF FSR
	MOVF SCL_BIT,W
	IORWF INDF,F
	GOTO IC28
IC23:	MOVF SCL_PORT,W
	MOVWF FSR
	COMF SCL_BIT,W
	ANDWF INDF,F
	GOTO IC28
IC28:	BSF FSR,7
	COMF INDF,W
	BCF FSR,7
	ANDWF INDF,F
IC29:	NOP
	NOP
	NOP
	NOP
	NOP
	NOP
	RETURN
IC24:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	MOVF SDA_BIT,W
	IORWF INDF,F
	RETURN
IC25:	MOVF SDA_PORT,W
	MOVWF FSR
	BSF FSR,7
	COMF SDA_BIT,W
	ANDWF INDF,F
	RETURN
; Begin of program
L0017:
; 1: 'program TT for PCBoard MGV145
; 2: 'version V3-1  Fiddle Yard version, for turntables and fiddle yard
; 3: 'this version has all possibilities changeable by menue's.
; 4: 'V3-2 counter for twisting cables tored at eeprom pos zero.
; 5: 'the value of the counter can be anything between 125 and 131. 128 is zero point.
; 6: 'V3-3 eeprom startup improved. Reprogramming PIC can now be done without reprogramming data
; 7: 'V3.6 startup delayed, to avoid wrong positions
; 8: 'V3.7 extra separate positions for FY and TT with contact sliders.
; 9: '-----MGV50 input changed, ramp-up and ramp-down activated, including separate settings for min and max speed
; 10: 'V4.1 inital setting for FY, set pos 1 and pos 2 correct, rest will be automatic.
; 11: 'V4.4 initial setting freespace dafaults to 0.
; 12: '-    positions 0 and 63 are allowed from I/O input >>>> 63 will be seen as 0
; 13: '-    manual position setting can be turned through zero
; 14: 'V4.5 extra menu 8 for setting the first position where rail power should be reversed
; 15: 'V4.6 0 point will also control cable twist
; 16: 'V4.7 Fiddle yard (ctrl type 6) has only 5 selection lines.(max 30 positions , 31 = zero adjust)
; 17: '-    pos.req 6 is set as input, MGV50 should be set as block output
; 18: '-    the two connection rails in and out are connected to current detection
; 19: '-    any train on these tracks will give siganl,where FY will stop immediately (same as endswitch)
; 20: 'V4.8 Extra menu added for settings of reverse/not per position (only for 0,2,4 )
; 21: '-    These bits (bridge_switch) are stored and read in 6 bytes
; 22: 'V4.9 Free_space_steps multiplied by 10 , 990 correction steps available
; 23: '-    Positions are changed to 0-47
; 24: '-    Maximum positons can be as low as two
; 25: 'V5.0 Correction for init eprom routine position change to 0-47
; 26: '-    Free_space_steps multiplier changed to 4
; 27: '-    Added position 62 for recalibration, turn in direction 0 until 0 detector reached and set position to 0
; 28: '-    Added menu option 9 to operate the stepper motor without changing the stored steps
; 29: 'V5.1 Correction for bug that when a position is at 0 steps (perfectly aligned zero detector)
; 30: '-    the "determine one round" routine is called when selecting that position
; 31: 'V5.2 Correction for relay control, only switch relays before and after moving, only when needed
; 32: '-    Menu 0 and 1 only available when posistion is a real position, not a special position (62, 63)
; 33: 'V5.3 Read bridge_power setting during initialisation
; 34: 'V5.4 Added option via menu 9 to use zero position detector to go to position 0, removed manual operation via menu 9
; 35: '-    When running clockwise (from high to low position) to position 0 run until zero detector signals
; 36: '-    when running counter clockwise run until zero detector goes back off again and then
; 37: '-    run in other direction until zero detector signals again. Show the number of stepds needed to reach zero
; 38: '-    detector again and store that as free_space_steps.
; 39: '-    added position 61 which is the same As position 62 but Then in other direction, run past zero detector,"
; 40: '-    run backwards until zero detector signals and store number of steps needed as free_space_steps
; 41: Define CONF_WORD = 0x3f72
; 42: Define CLOCK_FREQUENCY = 20
; 43: 'Define SIMULATION_WAITuS_VALUE = 1
; 44: Dim steps As Word
; 45: Dim half_steps As Word
; 46: Dim ramp_down_point As Word
; 47: Dim program_set As Byte
; 48: Dim new_steps As Word
; 49: Dim act_steps As Word
; 50: Dim new_pos As Byte
; 51: Dim act_pos As Byte
; 52: Dim one_round As Word
; 53: Dim one_round_half As Word
; 54: Dim bus_pos As Byte
; 55: Dim old_bus_pos As Byte
; 56: Dim speed As Word
; 57: Dim speed_min As Word
; 58: Dim speed_max As Word
; 59: Dim new_encoder As Byte
; 60: Dim old_encoder As Byte
; 61: Dim manual_pos As Byte
; 62: Dim old_manual_pos As Byte
; 63: Dim result As Byte
; 64: Dim free_space_steps As Byte
; 65: Dim free_space_word As Word
; 66: Dim value As Byte
; 67: Dim value2 As Byte
; 68: Dim eprom_pointer As Byte
; 69: Dim encoder_count As Byte
; 70: Dim turn_counter As Byte
; 71: Dim old_bridge_switch As Bit
; 72: Dim max_pos As Byte
; 73: Dim disp1_val As Byte
; 74: Dim disp2_val As Byte
; 75: Dim ctrl_type As Byte
; 76: Dim old_pos_write As Bit
; 77: Dim ramp_up As Bit
; 78: Dim speed_step As Byte
; 79: Dim version As Bit
; 80: Dim steps_set As Bit
; 81: Dim bridge_power As Bit
; 82: Dim bridge_switch As Bit
; 83: Dim use_zero_detector As Bit
; 84: Const disp1 = 64
; 85: Const disp2 = 66
; 86: Const mem_turn_counter = 101
; 87: Const mem_act_pos = 102
; 88: Const mem_speed_min = 103
; 89: Const mem_speed_max = 104
; 90: Const mem_speed_step = 105
; 91: Const mem_one_round_lb = 106
; 92: Const mem_one_round_hb = 107
; 93: Const mem_ctrl_type = 108
; 94: Const mem_max_pos = 109
; 95: Const mem_free_space = 110
; 96: 
; 97: Const mem_bridge_power = 112
; 98: Const mem_bridge_switch1 = 113
; 99: Const mem_bridge_switch2 = 114
; 100: Const mem_bridge_switch3 = 115
; 101: Const mem_bridge_switch4 = 116
; 102: Const mem_bridge_switch5 = 117
; 103: Const mem_bridge_switch6 = 118
; 104: Symbol swfw = RB0
; 105: Symbol swrev = RB1
; 106: Symbol sck = RB2
; 107: Symbol sda = RB3
; 108: Symbol pos_match = RB4
; 109: Symbol pos_write = RB5
; 110: Symbol eep = RB6
; 111: Symbol max_end = RB7
; 112: Symbol direction = RC0
; 113: Symbol clk = RC1
; 114: Symbol ena = RC2
; 115: Symbol zero = RC3
; 116: Symbol ec1 = RC4
; 117: Symbol ec2 = RC5
; 118: Symbol ecsw = RC6
; 119: Symbol pgm = RC7
; 120: Symbol fy_stop = RA5
; 121: ADCON1 = %0110
	MOVLW 0x06
	BSF STATUS,RP0
	MOVWF 0x1F
	BCF STATUS,RP0
; 122: TRISA = %111111
	MOVLW 0x3F
	BSF STATUS,RP0
	MOVWF 0x05
	BCF STATUS,RP0
; 123: TRISB = %11101100
	MOVLW 0xEC
	BSF STATUS,RP0
	MOVWF 0x06
	BCF STATUS,RP0
; 124: TRISC = %11111000
	MOVLW 0xF8
	BSF STATUS,RP0
	MOVWF 0x07
	BCF STATUS,RP0
; 125: PORTB = %11101100
	MOVLW 0xEC
	MOVWF 0x06
; 126: PORTC = %11111000
	MOVLW 0xF8
	MOVWF 0x07
; 127: I2CPrepare sda, sck
	MOVLW 0x06
	MOVWF SDA_PORT
	MOVLW 0x08
	MOVWF SDA_BIT
	BSF STATUS,RP0
	BCF TRISB,3
	BCF STATUS,RP0
	MOVLW 0x06
	MOVWF SCL_PORT
	MOVLW 0x04
	MOVWF SCL_BIT
	BSF STATUS,RP0
	BCF TRISB,2
	BCF STATUS,RP0
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
	CALL IC41
; 128: value = 54  'version number
	MOVLW 0x36
	MOVWF 0x30
; 129: Gosub init_values
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0011
; 130: value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 131: version = 1
	BSF 0x3B,5
; 132: Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 133: Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 134: old_bridge_switch = Not bridge_switch  'make sure that bridge power will be turned on
	BTFSS 0x3B,0
	BSF 0x3B,6
	BTFSC 0x3B,0
	BCF 0x3B,6
; 135: Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 136: program_set = 1
	MOVLW 0x01
	MOVWF 0x43
; 137: main:
L0001:
; 138: 	If pgm = 0 Then
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0018
; 139: 		Gosub adjust_settings
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0004
; 140: 		WaitMs 500
	MOVLW 0xF4
	MOVWF R0L
	MOVLW 0x01
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 141: 	Endif
L0018:
; 142: 
; 143: 	Gosub get_new_position
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0002
; 144: 	If bus_pos <> old_bus_pos Then
	MOVF 0x4B,W
	SUBWF 0x57,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0019
; 145: 		pos_match = 1  'indicate not in position
	BSF 0x06,4
; 146: 		If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0020
; 147: 			swfw = 0
	BCF 0x06,0
; 148: 			swrev = 0
	BCF 0x06,1
; 149: 		Endif
L0020:
; 150: 		new_pos = bus_pos
	MOVF 0x4B,W
	MOVWF 0x48
; 151: 		Gosub stepmotor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0007
; 152: 		value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 153: 		Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 154: 		Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 155: 		pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 156: 	Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0021
L0019:
; 157: 		If ecsw = 0 Then  'only when knob is pushed
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0022
; 158: 			If manual_pos <> old_manual_pos Then
	MOVF 0x3A,W
	SUBWF 0x52,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0023
; 159: 				pos_match = 1  'indicate not in position
	BSF 0x06,4
; 160: 				If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0024
; 161: 					swfw = 0
	BCF 0x06,0
; 162: 					swrev = 0
	BCF 0x06,1
; 163: 				Endif
L0024:
; 164: 				old_manual_pos = manual_pos
	MOVF 0x3A,W
	MOVWF 0x52
; 165: 				new_pos = manual_pos
	MOVF 0x3A,W
	MOVWF 0x48
; 166: 				Gosub stepmotor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0007
; 167: 				value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 168: 				Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 169: 				Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 170: 				pos_match = 0  'indicate pos_match
	BCF 0x06,4
; 171: 			Endif
L0023:
; 172: 		Endif
L0022:
; 173: 	Endif
L0021:
; 174: 	WaitMs 10
	MOVLW 0x0A
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 175: 	Goto main
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0001
; 176: End
;       PAGE SELECT
;	BCF PCLATH,3
L0025:	GOTO L0025
; 177: 
; 178: get_new_position:
L0002:
; 179: 	value = bus_pos  'remember the position
	MOVF 0x4B,W
	MOVWF 0x30
; 180: 	If pos_write = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,5
	GOTO L0026
; 181: 		If old_pos_write = 0 Then  'react only once on rising edge
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,7
	GOTO L0027
; 182: 			old_pos_write = 1
	BSF 0x3B,7
; 183: 			value = PORTA And 63  'now get value from J5
	MOVF 0x05,W
	MOVWF R0L
	MOVLW 0x3F
	ANDWF R0L,W
	MOVWF 0x30
; 184: 			If ctrl_type = 6 Then  'fiddle yard max = 30
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0028
; 185: 				value = value And 31
	MOVF 0x30,W
	MOVWF R0L
	MOVLW 0x1F
	ANDWF R0L,W
	MOVWF 0x30
; 186: 				If value = 31 Then  '31 is for zero adjust, maybe only 5 bits are available
	MOVF 0x30,W
	SUBLW 0x1F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0029
; 187: 					value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 188: 				Endif
L0029:
; 189: 			Endif
L0028:
; 190: 			Select Case value
; 191: 			Case 63  'make zero adjust
	MOVF 0x30,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0030
; 192: 				value = 0
	CLRF 0x30
; 193: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0031
L0030:
; 194: 				If value > max_pos Then  'this is not allowed
	MOVF 0x30,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0032
; 195: 					value = bus_pos  'put it back to old situation
	MOVF 0x4B,W
	MOVWF 0x30
; 196: 				Endif
L0032:
; 197: 			EndSelect
L0031:
; 198: 						Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 199: 			If value = bus_pos Then  'no other position is set, just a response on pos_write is required
	MOVF 0x30,W
	SUBWF 0x4B,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0033
; 200: 				pos_match = 1
	BSF 0x06,4
; 201: 				WaitMs 1000
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 202: 				pos_match = 0
	BCF 0x06,4
; 203: 			Endif
L0033:
; 204: 		Endif
L0027:
; 205: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0034
L0026:
; 206: 		old_pos_write = 0
	BCF 0x3B,7
; 207: 	Endif
L0034:
; 208: 	bus_pos = value  'now take over the desired position
	MOVF 0x30,W
	MOVWF 0x4B
; 209: 	Gosub calc_rotation
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0003
; 210: 	Select Case result
; 211: 	Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0035
; 212: 		If encoder_count < 4 Then
	MOVLW 0x04
	SUBWF 0x4E,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0036
; 213: 			encoder_count = encoder_count + 1
	MOVF 0x4E,W
	ADDLW 0x01
	MOVWF 0x4E
; 214: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0037
L0036:
; 215: 			encoder_count = 0
	CLRF 0x4E
; 216: 			Select Case manual_pos
; 217: 			Case 63
	MOVF 0x3A,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0038
; 218: 				manual_pos = 0
	CLRF 0x3A
; 219: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0039
L0038:
	MOVF 0x3A,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0040
; 220: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x3A
; 221: 			Case 61
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0041
L0040:
	MOVF 0x3A,W
	SUBLW 0x3D
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0042
; 222: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x3A
; 223: 			Case max_pos
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0043
L0042:
	MOVF 0x3A,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0044
; 224: 				manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x3A
; 225: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0045
L0044:
; 226: 				manual_pos = manual_pos + 1
	MOVF 0x3A,W
	ADDLW 0x01
	MOVWF 0x3A
; 227: 			EndSelect
L0045:
L0043:
L0041:
L0039:
; 228: 			value = manual_pos
	MOVF 0x3A,W
	MOVWF 0x30
; 229: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 230: 		Endif
L0037:
; 231: 	Case 2
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0046
L0035:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0047
; 232: 		If encoder_count > 0 Then
	MOVF 0x4E,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0048
; 233: 			encoder_count = encoder_count - 1
	MOVLW 0x01
	SUBWF 0x4E,W
	MOVWF 0x4E
; 234: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0049
L0048:
; 235: 			encoder_count = 4
	MOVLW 0x04
	MOVWF 0x4E
; 236: 			Select Case manual_pos
; 237: 			Case 63
	MOVF 0x3A,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0050
; 238: 				manual_pos = 62
	MOVLW 0x3E
	MOVWF 0x3A
; 239: 			Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0051
L0050:
	MOVF 0x3A,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0052
; 240: 				manual_pos = 61
	MOVLW 0x3D
	MOVWF 0x3A
; 241: 			Case 61
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0053
L0052:
	MOVF 0x3A,W
	SUBLW 0x3D
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0054
; 242: 				manual_pos = max_pos
	MOVF 0x33,W
	MOVWF 0x3A
; 243: 			Case 0
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0055
L0054:
	MOVF 0x3A,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0056
; 244: 				manual_pos = 63
	MOVLW 0x3F
	MOVWF 0x3A
; 245: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0057
L0056:
; 246: 				manual_pos = manual_pos - 1
	MOVLW 0x01
	SUBWF 0x3A,W
	MOVWF 0x3A
; 247: 			EndSelect
L0057:
L0055:
L0053:
L0051:
; 248: 			value = manual_pos
	MOVF 0x3A,W
	MOVWF 0x30
; 249: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 250: 		Endif
L0049:
; 251: 	Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0058
L0047:
; 252: 	EndSelect
L0058:
L0046:
; 253: 	WaitMs 1
	MOVLW 0x01
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 254: 	
; 255: Return
	RETURN
; 256: 
; 257: calc_rotation:  'this routine checks the incrimental switch
L0003:
; 258: '1 = increasing value
; 259: '2 = decreasing value
; 260: '3 = no change
; 261: 		new_encoder = 0
	CLRF 0x4D
; 262: 		new_encoder.0 = ec1
	BTFSC 0x07,4
	BSF 0x4D,0
	BTFSS 0x07,4
	BCF 0x4D,0
; 263: 		new_encoder.1 = ec2
	BTFSC 0x07,5
	BSF 0x4D,1
	BTFSS 0x07,5
	BCF 0x4D,1
; 264: 		Select Case old_encoder
; 265: 		Case 0
	MOVF 0x51,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0059
; 266: 			result = LookUp(3, 2, 1, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0060
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0001
	MOVWF 0x3F
L0060:
; 267: 		Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0061
L0059:
	MOVF 0x51,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0062
; 268: 			result = LookUp(1, 3, 3, 2), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0063
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0002
	MOVWF 0x3F
L0063:
; 269: 		Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0064
L0062:
	MOVF 0x51,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0065
; 270: 			result = LookUp(2, 3, 3, 1), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0066
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0003
	MOVWF 0x3F
L0066:
; 271: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0067
L0065:
; 272: 			result = LookUp(3, 1, 2, 3), new_encoder
	MOVF 0x4D,W
	MOVWF R0L
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0068
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0004
	MOVWF 0x3F
L0068:
; 273: 		EndSelect
L0067:
L0064:
L0061:
; 274: 		old_encoder = new_encoder
	MOVF 0x4D,W
	MOVWF 0x51
; 275: Return
	RETURN
; 276: 
; 277: adjust_settings:
L0004:
; 278: 	If program_set = 0 Or program_set = 1 Then  'menu 0 and 1 not available when position has a special value (62, 63)
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0071
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0070
L0071:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0069
L0070:
; 279: 		If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0072
	MOVF 0x3A,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0072
	MOVF 0x4B,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0072
; 280: 			program_set = program_set
; 281: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0073
L0072:
; 282: 			program_set = 2
	MOVLW 0x02
	MOVWF 0x43
; 283: 		Endif
L0073:
; 284: 	Endif
L0069:
; 285: 	If bridge_power = 0 Then  'bridge railpower must be switched off
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0074
; 286: 		swfw = 0
	BCF 0x06,0
; 287: 		swrev = 0
	BCF 0x06,1
; 288: 	Endif
L0074:
; 289: 	Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 290: 	WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 291: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 292: 	new_steps = act_steps  'nothing is changed yet
	MOVF 0x45,W
	MOVWF 0x36
	MOVF 0x46,W
	MOVWF 0x37
; 293: 	While pgm = 0  'the program switch is still activated
L0075:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0076
; 294: 		If ecsw = 0 Then  'knob is pressed, increase program_set
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0077
; 295: 			program_set = program_set + 1
	MOVF 0x43,W
	ADDLW 0x01
	MOVWF 0x43
; 296: 			If program_set > 9 Then  'no more than 9 items te change
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0078
; 297: 				If act_pos <= max_pos And manual_pos <= max_pos And bus_pos <= max_pos Then  'menu 0 and 1 only available when position is not a special position
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0079
	MOVF 0x3A,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0079
	MOVF 0x4B,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0079
; 298: 					program_set = 0
	CLRF 0x43
; 299: 				Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0080
L0079:
; 300: 					program_set = 2
	MOVLW 0x02
	MOVWF 0x43
; 301: 				Endif
L0080:
; 302: 			Endif
L0078:
; 303: 			Gosub i2c_display_pgm
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0006
; 304: 			WaitMs 800  'give some time for display to be read
	MOVLW 0x20
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 305: 			While ecsw = 0  'be sure pushbutton is released
L0081:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,6
	GOTO L0082
; 306: 				WaitMs 250  'cancel contact dender
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 307: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0081
L0082:
; 308: 		Endif
L0077:
; 309: 		Select Case program_set
; 310: 		Case 0  'correction of current position
	MOVF 0x43,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0083
; 311: 			value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 312: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 313: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 314: 			Select Case result
; 315: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0084
; 316: 				If new_steps < 60000 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0085
; 317: 					ena = 1  'motor on
	BSF 0x07,2
; 318: 					new_steps = new_steps + 1
	MOVF 0x36,W
	ADDLW 0x01
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x37
; 319: 					direction = 1
	BSF 0x07,0
; 320: 					clk = 1  'clock out
	BSF 0x07,1
; 321: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 322: 					clk = 0
	BCF 0x07,1
; 323: 				Endif
L0085:
; 324: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0086
L0084:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0087
; 325: 				If new_steps > 0 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0088
; 326: 					ena = 1  'motor on
	BSF 0x07,2
; 327: 					new_steps = new_steps - 1
	MOVLW 0x01
	SUBWF 0x36,W
	MOVWF 0x36
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x37
; 328: 					direction = 0
	BCF 0x07,0
; 329: 					clk = 1  'clock out
	BSF 0x07,1
; 330: 					WaitMs 5
	MOVLW 0x05
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 331: 					clk = 0
	BCF 0x07,1
; 332: 				Endif
L0088:
; 333: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0089
L0087:
; 334: 			EndSelect
L0089:
L0086:
; 335: 			Select Case act_pos
; 336: 			Case 1
	MOVF 0x31,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0090
; 337: 				steps_set = 1
	BSF 0x3B,1
; 338: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0091
L0090:
	MOVF 0x31,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0092
; 339: 				If steps_set = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3B,1
	GOTO L0093
; 340: 					If eep = 1 Then  'iF jumper eep1 is set to on
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0094
; 341: 											'routine to set steps for pos 3 to max_pos
; 342: 						value = 63
	MOVLW 0x3F
	MOVWF 0x30
; 343: 						Gosub i2c_display  'show 63 to indicate adjusting is proceeded
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 344: 						If act_steps <> new_steps Then
	MOVF 0x45,W
	MOVWF R0L
	MOVF 0x46,W
	MOVWF R0H
	MOVF 0x36,W
	MOVWF R1L
	MOVF 0x37,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0095
; 345: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 346: 						Endif
L0095:
; 347: 						act_pos = 1
	MOVLW 0x01
	MOVWF 0x31
; 348: 						new_pos = 2
	MOVLW 0x02
	MOVWF 0x48
; 349: 						Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 350: 						steps = new_steps - act_steps  'calculate difference between one and two
	MOVF 0x45,W
	SUBWF 0x36,W
	MOVWF 0x34
	MOVF 0x46,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x35
; 351: 						For act_pos = 3 To max_pos
	MOVLW 0x03
	MOVWF 0x31
L0096:
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0097
; 352: 							new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x34,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x35,W
	MOVWF 0x37
; 353: 							Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 354: 						Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0096
L0097:
; 355: 						WaitMs 2000  'give some timne to read display
	MOVLW 0xD0
	MOVWF R0L
	MOVLW 0x07
	MOVWF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 356: 						act_pos = 2  'we were at this position
	MOVLW 0x02
	MOVWF 0x31
; 357: 						steps_set = 0  'do this routine only once
	BCF 0x3B,1
; 358: 					Endif
L0094:
; 359: 				Endif
L0093:
; 360: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0098
L0092:
; 361: 				steps_set = 0
	BCF 0x3B,1
; 362: 			EndSelect  'act_pos
L0098:
L0091:
; 363: 		Case 1  'setting of inverse / not inverse bridge rail power
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0099
L0083:
	MOVF 0x43,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0100
; 364: 			Gosub read_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0013
; 365: 			value = 0
	CLRF 0x30
; 366: 			value.0 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,0
	BTFSS 0x3B,0
	BCF 0x30,0
; 367: 			Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 368: 			Gosub calc_rotation  'look for the knob to be turned
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 369: 			Select Case result
; 370: 			Case 1, 2
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0103
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0102
L0103:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0101
L0102:
; 371: 				bridge_switch = Not bridge_switch
	MOVLW 0x01
	XORWF 0x3B,F
; 372: 				Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 373: 				swfw = bridge_switch
	BTFSC 0x3B,0
	BSF 0x06,0
	BTFSS 0x3B,0
	BCF 0x06,0
; 374: 				swrev = Not bridge_switch
	BTFSS 0x3B,0
	BSF 0x06,1
	BTFSC 0x3B,0
	BCF 0x06,1
; 375: 			Case Else
;       PAGE SELECT
	BCF PCLATH,3
	GOTO L0104
L0101:
; 376: 			EndSelect
L0104:
; 377: 		Case 2  'setting of maximum positions
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0105
L0100:
	MOVF 0x43,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0106
; 378: 			steps_set = 0
	BCF 0x3B,1
; 379: 			ena = 0  'shut off motor
	BCF 0x07,2
; 380: 			value = max_pos
	MOVF 0x33,W
	MOVWF 0x30
; 381: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 382: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 383: 			Select Case result
; 384: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0107
; 385: 				max_pos = max_pos + 1
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x33
; 386: 				Select Case ctrl_type
; 387: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0108
; 388: 					If max_pos > 30 Then  'no more positions possible
	MOVF 0x33,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0109
; 389: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x33
; 390: 					Endif
L0109:
; 391: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0110:	BTFSC EECON1,WR
	GOTO L0110
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 392: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0111
L0108:
; 393: 					If max_pos > 47 Then  'no more positions possible
	MOVF 0x33,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0112
; 394: 						max_pos = 1
	MOVLW 0x01
	MOVWF 0x33
; 395: 					Endif
L0112:
; 396: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0113:	BTFSC EECON1,WR
	GOTO L0113
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 397: 				EndSelect
L0111:
; 398: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0114
L0107:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0115
; 399: 				max_pos = max_pos - 1
	MOVLW 0x01
	SUBWF 0x33,W
	MOVWF 0x33
; 400: 				If max_pos < 1 Then  'mininum 2 positions
	MOVLW 0x01
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0116
; 401: 					Select Case ctrl_type
; 402: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0117
; 403: 						max_pos = 30
	MOVLW 0x1E
	MOVWF 0x33
; 404: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0118
L0117:
; 405: 						max_pos = 47
	MOVLW 0x2F
	MOVWF 0x33
; 406: 					EndSelect
L0118:
; 407: 					Write mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x33,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0119:	BTFSC EECON1,WR
	GOTO L0119
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 408: 				Endif
L0116:
; 409: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0120
L0115:
; 410: 			EndSelect
L0120:
L0114:
; 411: 		Case 3  'setting control type
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0121
L0106:
	MOVF 0x43,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0122
; 412: 			steps_set = 0
	BCF 0x3B,1
; 413: 			ena = 0  'shut off motor
	BCF 0x07,2
; 414: 			If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0123
; 415: 				ctrl_type = 0
	CLRF 0x32
; 416: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0124:	BTFSC EECON1,WR
	GOTO L0124
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 417: 			Endif
L0123:
; 418: 			value = ctrl_type
	MOVF 0x32,W
	MOVWF 0x30
; 419: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 420: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 421: 			Select Case result
; 422: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0125
; 423: 				ctrl_type = ctrl_type + 1
	MOVF 0x32,W
	ADDLW 0x01
	MOVWF 0x32
; 424: 				If ctrl_type = 7 Then
	MOVF 0x32,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0126
; 425: 					ctrl_type = 0
	CLRF 0x32
; 426: 				Endif
L0126:
; 427: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0127:	BTFSC EECON1,WR
	GOTO L0127
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 428: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0128
L0125:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0129
; 429: 				ctrl_type = ctrl_type - 1
	MOVLW 0x01
	SUBWF 0x32,W
	MOVWF 0x32
; 430: 				If ctrl_type = 255 Then
	MOVF 0x32,W
	SUBLW 0xFF
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0130
; 431: 					ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 432: 				Endif
L0130:
; 433: 				Write mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x32,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0131:	BTFSC EECON1,WR
	GOTO L0131
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 434: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0132
L0129:
; 435: 			EndSelect
L0132:
L0128:
; 436: 		Case 4  'setting of speed interval Minimum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0133
L0122:
	MOVF 0x43,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0134
; 437: 					'setting will be done in multiple of 256 uSecs
; 438: 					'minimum is 2 and maximum is 99 (is real slow)
; 439: 			steps_set = 0
	BCF 0x3B,1
; 440: 			ena = 0  'shut off motor
	BCF 0x07,2
; 441: 			value = speed_min.HB
	MOVF 0x3E,W
	MOVWF 0x30
; 442: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 443: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 444: 			Select Case result
; 445: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0135
; 446: 				If speed_min.HB < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x3E,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0136
; 447: 					speed_min = speed_min + 256
	MOVF 0x3D,W
	ADDLW 0x00
	MOVWF 0x3D
	MOVF 0x3E,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x01
	MOVWF 0x3E
; 448: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0137:	BTFSC EECON1,WR
	GOTO L0137
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 449: 				Endif
L0136:
; 450: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0138
L0135:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0139
; 451: 				If speed_min > speed_max Then
	MOVF 0x3D,W
	MOVWF R0L
	MOVF 0x3E,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0140
; 452: 					speed_min = speed_min - 256
	MOVLW 0x00
	SUBWF 0x3D,W
	MOVWF 0x3D
	MOVLW 0x01
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x3E,W
	MOVWF 0x3E
; 453: 					Write mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3E,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0141:	BTFSC EECON1,WR
	GOTO L0141
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 454: 				Endif
L0140:
; 455: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0142
L0139:
; 456: 			EndSelect
L0142:
L0138:
; 457: 		Case 5  'setting of speed interval Maximum
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0143
L0134:
	MOVF 0x43,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0144
; 458: 					'setting will be done in multiple of 256 uSecs
; 459: 					'minimum is 1 and maximum is 99 (is real slow)
; 460: 			steps_set = 0
	BCF 0x3B,1
; 461: 			ena = 0  'shut off motor
	BCF 0x07,2
; 462: 			value = speed_max.HB
	MOVF 0x39,W
	MOVWF 0x30
; 463: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 464: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 465: 			Select Case result
; 466: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0145
; 467: 				If speed_max.HB < speed_min.HB Then  'not more then speed_min
	MOVF 0x3E,W
	SUBWF 0x39,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0146
; 468: 					speed_max.HB = speed_max.HB + 1
	MOVF 0x39,W
	ADDLW 0x01
	MOVWF 0x39
; 469: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0147:	BTFSC EECON1,WR
	GOTO L0147
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 470: 				Endif
L0146:
; 471: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0148
L0145:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0149
; 472: 				If speed_max.HB > 1 Then
	MOVF 0x39,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0150
; 473: 					speed_max.HB = speed_max.HB - 1
	MOVLW 0x01
	SUBWF 0x39,W
	MOVWF 0x39
; 474: 					Write mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x39,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0151:	BTFSC EECON1,WR
	GOTO L0151
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 475: 				Endif
L0150:
; 476: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0152
L0149:
; 477: 			EndSelect
L0152:
L0148:
; 478: 		Case 6  'setting of ramp up and down speed
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0153
L0144:
	MOVF 0x43,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0154
; 479: 					'speed will be the value that speed will be changed every step up and down
; 480: 			steps_set = 0
	BCF 0x3B,1
; 481: 			ena = 0  'shut off motor
	BCF 0x07,2
; 482: 			value = speed_step
	MOVF 0x47,W
	MOVWF 0x30
; 483: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 484: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 485: 			Select Case result
; 486: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0155
; 487: 				If speed_step < 99 Then  'maximum 99 is possible
	MOVLW 0x63
	SUBWF 0x47,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0156
; 488: 					speed_step = speed_step + 1
	MOVF 0x47,W
	ADDLW 0x01
	MOVWF 0x47
; 489: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0157:	BTFSC EECON1,WR
	GOTO L0157
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 490: 				Endif
L0156:
; 491: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0158
L0155:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0159
; 492: 				If speed_step > 1 Then
	MOVF 0x47,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0160
; 493: 					speed_step = speed_step - 1
	MOVLW 0x01
	SUBWF 0x47,W
	MOVWF 0x47
; 494: 					Write mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x47,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0161:	BTFSC EECON1,WR
	GOTO L0161
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 495: 				Endif
L0160:
; 496: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0162
L0159:
; 497: 			EndSelect
L0162:
L0158:
; 498: 	
; 499: 		Case 7  'setting of extra free space steps
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0163
L0154:
	MOVF 0x43,W
	SUBLW 0x07
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0164
; 500: 			steps_set = 0
	BCF 0x3B,1
; 501: 			ena = 0  'shut off motor
	BCF 0x07,2
; 502: 			If free_space_steps > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0165
; 503: 				free_space_steps = 99
	MOVLW 0x63
	MOVWF 0x44
; 504: 				Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0166:	BTFSC EECON1,WR
	GOTO L0166
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 505: 			Endif
L0165:
; 506: 			value = free_space_steps
	MOVF 0x44,W
	MOVWF 0x30
; 507: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 508: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 509: 			Select Case result
; 510: 			Case 1
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0167
; 511: 				If free_space_steps < 99 Then  'display is limited to 99
	MOVLW 0x63
	SUBWF 0x44,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0168
; 512: 					free_space_steps = free_space_steps + 1
	MOVF 0x44,W
	ADDLW 0x01
	MOVWF 0x44
; 513: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0169:	BTFSC EECON1,WR
	GOTO L0169
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 514: 				Endif
L0168:
; 515: 			Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0170
L0167:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0171
; 516: 				If free_space_steps > 0 Then
	MOVF 0x44,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0172
; 517: 					free_space_steps = free_space_steps - 1
	MOVLW 0x01
	SUBWF 0x44,W
	MOVWF 0x44
; 518: 					Write mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x44,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0173:	BTFSC EECON1,WR
	GOTO L0173
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 519: 				Endif
L0172:
; 520: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0174
L0171:
; 521: 			EndSelect
L0174:
L0170:
; 522: 		Case 8  'setting if power should be on or off while bridge is moving (0 = off)
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0175
L0164:
	MOVF 0x43,W
	SUBLW 0x08
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0176
; 523: 			Read mem_bridge_power, value2
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 524: 			bridge_power = value2.0
	BTFSC 0x3C,0
	BSF 0x3B,2
	BTFSS 0x3C,0
	BCF 0x3B,2
; 525: 			value = 0
	CLRF 0x30
; 526: 			value.0 = bridge_power
	BTFSC 0x3B,2
	BSF 0x30,0
	BTFSS 0x3B,2
	BCF 0x30,0
; 527: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 528: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 529: 			Select Case result
; 530: 			Case 1, 2
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0179
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0178
L0179:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0177
L0178:
; 531: 				bridge_power = Not bridge_power
	MOVLW 0x04
	XORWF 0x3B,F
; 532: 				value2.0 = bridge_power
	BTFSC 0x3B,2
	BSF 0x3C,0
	BTFSS 0x3B,2
	BCF 0x3C,0
; 533: 				Write mem_bridge_power, value2
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0180:	BTFSC EECON1,WR
	GOTO L0180
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 534: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0181
L0177:
; 535: 			EndSelect
L0181:
; 536: 		Case 9  'setting if zero position detector should be used to turn to position 0 (0 = no)
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0182
L0176:
	MOVF 0x43,W
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0183
; 537: 			Read mem_bridge_power, value2
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3C
; 538: 			use_zero_detector = value2.1
	BTFSC 0x3C,1
	BSF 0x3B,3
	BTFSS 0x3C,1
	BCF 0x3B,3
; 539: 			value = 0
	CLRF 0x30
; 540: 			value.0 = use_zero_detector
	BTFSC 0x3B,3
	BSF 0x30,0
	BTFSS 0x3B,3
	BCF 0x30,0
; 541: 			Gosub i2c_display
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 542: 			Gosub calc_rotation
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0003
; 543: 			Select Case result
; 544: 			Case 1, 2
	MOVF 0x3F,W
	SUBLW 0x01
;       PAGE SELECT
	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0186
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0185
L0186:
	MOVF 0x3F,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0184
L0185:
; 545: 				use_zero_detector = Not use_zero_detector
	MOVLW 0x08
	XORWF 0x3B,F
; 546: 				value2.1 = use_zero_detector
	BTFSC 0x3B,3
	BSF 0x3C,1
	BTFSS 0x3B,3
	BCF 0x3C,1
; 547: 				Write mem_bridge_power, value2
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x3C,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0187:	BTFSC EECON1,WR
	GOTO L0187
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 548: 			Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0188
L0184:
; 549: 			EndSelect
L0188:
; 550: 		EndSelect
L0183:
L0182:
L0175:
L0163:
L0153:
L0143:
L0133:
L0121:
L0105:
L0099:
; 551: 	Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0075
L0076:
; 552: 	ena = 0  'shut off motor
	BCF 0x07,2
; 553: 		'***************   now check if changes have to BE written in eeprom
; 554: 	If new_steps <> act_steps Then  'now save new position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x45,W
	MOVWF R1L
	MOVF 0x46,W
	MOVWF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C002
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0189
; 555: 		Gosub save_steps
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0015
; 556: 	Endif
L0189:
; 557: 	value = act_pos
	MOVF 0x31,W
	MOVWF 0x30
; 558: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 559: 	Gosub set_relays
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0009
; 560: Return
	RETURN
; 561: 
; 562: i2c_display:
L0005:
; 563: 	disp1_val = value
	MOVF 0x30,W
	MOVWF 0x4C
; 564: 	disp1_val = disp1_val Mod 10
	MOVF 0x4C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x4C
; 565: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), disp1_val
	MOVF 0x4C,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0190
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0005
	MOVWF 0x4C
L0190:
; 566: 	disp1_val.7 = pgm
	BTFSC 0x07,7
	BSF 0x4C,7
	BTFSS 0x07,7
	BCF 0x4C,7
; 567: 	disp2_val = value
	MOVF 0x30,W
	MOVWF 0x4F
; 568: 	disp2_val = disp2_val / 10
	MOVF 0x4F,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x0A
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x4F
; 569: 	disp2_val = LookUp(%11111111, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000, %10111111), disp2_val
	MOVF 0x4F,W
	MOVWF R0L
	SUBLW 0x0A
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0191
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0006
	MOVWF 0x4F
L0191:
; 570: 	disp2_val.7 = version
	BTFSC 0x3B,5
	BSF 0x4F,7
	BTFSS 0x3B,5
	BCF 0x4F,7
; 571: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 572: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 573: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 574: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 575: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 576: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 577: 	I2CSend disp2_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4F,W
	CALL IC01
; 578: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 579: Return
	RETURN
; 580: 
; 581: i2c_display_pgm:
L0006:
; 582: 	disp1_val = LookUp(%11000000, %11111001, %10100100, %10110000, %10011001, %10010010, %10000010, %11111000, %10000000, %10010000), program_set
	MOVF 0x43,W
	MOVWF R0L
	SUBLW 0x09
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0192
;       PAGE SELECT
;	BCF PCLATH,3
	CALL _lookup_lab_0007
	MOVWF 0x4C
L0192:
; 583: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 584: 	I2CSend disp1
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x40
	CALL IC01
; 585: 	I2CSend disp1_val
;       PAGE SELECT
;	BCF PCLATH,3
	MOVF 0x4C,W
	CALL IC01
; 586: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 587: 	I2CStart
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC31
; 588: 	I2CSend disp2
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0x42
	CALL IC01
; 589: 	I2CSend %10111111
;       PAGE SELECT
;	BCF PCLATH,3
	MOVLW 0xBF
	CALL IC01
; 590: 	I2CStop
;       PAGE SELECT
;	BCF PCLATH,3
	CALL IC41
; 591: Return
	RETURN
; 592: 
; 593: stepmotor:
L0007:
; 594: 	speed = 0
	CLRF 0x49
	CLRF 0x4A
; 595: 	Gosub steps_reading
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0012
; 596: 	If new_steps > 65532 Then  'goto 0 detector position
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0xFC
	MOVWF R1L
	MOVLW 0xFF
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0193
; 597: 		If new_steps = 65533 Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVLW 0xFD
	MOVWF R1L
	MOVLW 0xFF
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0194
; 598: 			direction = 1  'go clockwise
	BSF 0x07,0
; 599: 			ena = 1  'set enable on
	BSF 0x07,2
; 600: 			While zero = 1  'turn motor until zero switch is activated
L0195:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0196
; 601: 				clk = 1  'clock out
	BSF 0x07,1
; 602: 				WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 603: 				clk = 0
	BCF 0x07,1
; 604: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 605: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0195
L0196:
; 606: 			While zero = 0  'continue to run until zero detector no longer signals
L0197:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0198
; 607: 				clk = 1  'clock out
	BSF 0x07,1
; 608: 				WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 609: 				clk = 0
	BCF 0x07,1
; 610: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 611: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0197
L0198:
; 612: 			WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL W001
; 613: 			direction = 0  'now go clockwise
	BCF 0x07,0
; 614: 			value = 0
	CLRF 0x30
; 615: 			While zero = 1  'run until zero detector signals
L0199:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0200
; 616: 				clk = 1
	BSF 0x07,1
; 617: 				WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 618: 				clk = 0
	BCF 0x07,1
; 619: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 620: 				value = value + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 621: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0199
L0200:
; 622: 			value = value / 4
	MOVF 0x30,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
; 623: 			If value > 99 Then
	MOVF 0x30,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0201
; 624: 				value = 99
	MOVLW 0x63
	MOVWF 0x30
; 625: 			Endif
L0201:
; 626: 			Write mem_free_space, value
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0202:	BTFSC EECON1,WR
	GOTO L0202
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 627: 			Gosub i2c_display  'show number of steps needed, indication of free_space_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0005
; 628: 			WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 629: 		Else  'go counterclockwise
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0203
L0194:
; 630: 			direction = 0
	BCF 0x07,0
; 631: 			ena = 1  'set enable on
	BSF 0x07,2
; 632: 			While zero = 1  'turn motor until zero switch is activated
L0204:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0205
; 633: 				clk = 1  'clock out
	BSF 0x07,1
; 634: 				WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 635: 				clk = 0
	BCF 0x07,1
; 636: 				WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 637: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0204
L0205:
; 638: 		Endif
L0203:
; 639: 		ena = 0  'set enable off
	BCF 0x07,2
; 640: 		If act_steps = 0 Then
	MOVF 0x45,W
	MOVWF R0L
	MOVF 0x46,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0206
; 641: 			new_pos = 0
	CLRF 0x48
; 642: 		Else  'one_round count to be done
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0207
L0206:
; 643: 			act_steps = 0
	CLRF 0x45
	CLRF 0x46
; 644: 			value = 0  'first considerate that extra round is not allowed
	CLRF 0x30
; 645: 			Select Case ctrl_type
; 646: 			Case 2, 3  'check if extra round is allowed
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0210
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0209
L0210:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0208
L0209:
; 647: 				Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 648: 				Select Case turn_counter
; 649: 				Case > 126  'check if shortest way is allowed
	MOVF 0x42,W
	SUBLW 0x7E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0211
; 650: 					turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 651: 					Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0212:	BTFSC EECON1,WR
	GOTO L0212
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 652: 					value = 1  'now it is allowed
	MOVLW 0x01
	MOVWF 0x30
; 653: 				Case < 126
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0213
L0211:
	MOVLW 0x7E
	SUBWF 0x42,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0214
; 654: 					Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0215:	BTFSC EECON1,WR
	GOTO L0215
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 655: 				Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0216
L0214:
; 656: 				EndSelect
L0216:
L0213:
; 657: 			Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0217
L0208:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0220
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0219
L0220:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0218
L0219:
; 658: 				value = 1
	MOVLW 0x01
	MOVWF 0x30
; 659: 			Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0221
L0218:
; 660: 			EndSelect
L0221:
L0217:
; 661: 			If value = 1 Then
	MOVF 0x30,W
	SUBLW 0x01
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0222
; 662: 				one_round = 0  'start counting one round steps
	CLRF 0x40
	CLRF 0x41
; 663: 				ena = 1  'set enable on
	BSF 0x07,2
; 664: 				While zero = 0  'turn motor until zero switch is DISactivated
L0223:
;       PAGE SELECT
	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0224
; 665: 					clk = 1  'clock out
	BSF 0x07,1
; 666: 					WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 667: 					clk = 0
	BCF 0x07,1
; 668: 					one_round = one_round + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
	MOVF 0x41,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x41
; 669: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 670: 				Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0223
L0224:
; 671: 				For value = 1 To 100  'SOME MORE STEPS TO AVOID CONTACT DENDER.
	MOVLW 0x01
	MOVWF 0x30
L0225:
	MOVF 0x30,W
	SUBLW 0x64
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0226
; 672: 					clk = 1  'clock out
	BSF 0x07,1
; 673: 					WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 674: 					clk = 0
	BCF 0x07,1
; 675: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 676: 					one_round = one_round + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
	MOVF 0x41,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x41
; 677: 				Next value
	MOVLW 0x01
	ADDWF 0x30,F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0225
L0226:
; 678: 				While zero = 1  'turn motor until zero switch is activated
L0227:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0228
; 679: 					clk = 1  'clock out
	BSF 0x07,1
; 680: 					WaitUs speed_max
	MOVF 0x38,W
	MOVWF R4L
	MOVF 0x39,W
	MOVWF R4H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL Y001
; 681: 					clk = 0
	BCF 0x07,1
; 682: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 683: 					one_round = one_round + 1
	MOVF 0x40,W
	ADDLW 0x01
	MOVWF 0x40
	MOVF 0x41,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x41
; 684: 				Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0227
L0228:
; 685: 				one_round_half = one_round / 2
	MOVF 0x40,W
	MOVWF R0L
	MOVF 0x41,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
;	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 686: 				Write mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x40,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
	BSF PCLATH,3
L0229:	BTFSC EECON1,WR
	GOTO L0229
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 687: 				Write mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x41,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0230:	BTFSC EECON1,WR
	GOTO L0230
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 688: 				act_pos = 63
	MOVLW 0x3F
	MOVWF 0x31
; 689: 			Endif
L0222:
; 690: 			Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0231:	BTFSC EECON1,WR
	GOTO L0231
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 691: 			ena = 0  'set enable off
	BCF 0x07,2
; 692: 		Endif
L0207:
; 693: 	Else  'this is the normal position sequence
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0232
L0193:
; 694: 		steps = 0
	CLRF 0x34
	CLRF 0x35
; 695: 		If new_steps > act_steps Then
	MOVF 0x36,W
	MOVWF R0L
	MOVF 0x37,W
	MOVWF R0H
	MOVF 0x45,W
	MOVWF R1L
	MOVF 0x46,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0233
; 696: 			steps = new_steps - act_steps
	MOVF 0x45,W
	SUBWF 0x36,W
	MOVWF 0x34
	MOVF 0x46,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x37,W
	MOVWF 0x35
; 697: 			direction = 1
	BSF 0x07,0
; 698: 			If steps > one_round_half Then  'is other direction shorter?
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0234
; 699: 				Select Case ctrl_type
; 700: 				Case 2, 3
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0237
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0236
L0237:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0235
L0236:
; 701: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 702: 					Select Case turn_counter
; 703: 					Case > 126  'check if shortest way is allowed
	MOVF 0x42,W
	SUBLW 0x7E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0238
; 704: 						turn_counter = turn_counter - 1  'yes it is, so substract one pass
	MOVLW 0x01
	SUBWF 0x42,W
	MOVWF 0x42
; 705: 						steps = one_round - steps  'go shortest way
	MOVF 0x34,W
	SUBWF 0x40,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x41,W
	MOVWF 0x35
; 706: 						direction = 0  'change  direction
	BCF 0x07,0
; 707: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0239:	BTFSC EECON1,WR
	GOTO L0239
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 708: 					Case < 126
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0240
L0238:
	MOVLW 0x7E
	SUBWF 0x42,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0241
; 709: 							Write mem_turn_counter, 126
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x7E
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0242:	BTFSC EECON1,WR
	GOTO L0242
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 710: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0243
L0241:
; 711: 					EndSelect
L0243:
L0240:
; 712: 				Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0244
L0235:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0247
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0246
L0247:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0245
L0246:
; 713: 					steps = one_round - steps
	MOVF 0x34,W
	SUBWF 0x40,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x41,W
	MOVWF 0x35
; 714: 					direction = 0
	BCF 0x07,0
; 715: 				Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0248
L0245:
; 716: 				EndSelect
L0248:
L0244:
; 717: 			Endif
L0234:
; 718: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0249
L0233:
; 719: 			steps = act_steps - new_steps
	MOVF 0x36,W
	SUBWF 0x45,W
	MOVWF 0x34
	MOVF 0x37,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x46,W
	MOVWF 0x35
; 720: 			direction = 0
	BCF 0x07,0
; 721: 			If steps > one_round_half Then  'other direction shorter?
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x55,W
	MOVWF R1L
	MOVF 0x56,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0250
; 722: 				Select Case ctrl_type
; 723: 				Case 2, 3  'cable connected bridges
	MOVF 0x32,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0253
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0252
L0253:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0251
L0252:
; 724: 					Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 725: 					Select Case turn_counter
; 726: 					Case < 130
	MOVLW 0x82
	SUBWF 0x42,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0254
; 727: 						turn_counter = turn_counter + 1  'yes it is, so add one pass
	MOVF 0x42,W
	ADDLW 0x01
	MOVWF 0x42
; 728: 						steps = one_round - steps  'go shortest way
	MOVF 0x34,W
	SUBWF 0x40,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x41,W
	MOVWF 0x35
; 729: 						direction = 1  'change direction
	BSF 0x07,0
; 730: 						Write mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x42,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0255:	BTFSC EECON1,WR
	GOTO L0255
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 731: 					Case > 130
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0256
L0254:
	MOVF 0x42,W
	SUBLW 0x82
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0257
; 732: 						Write mem_turn_counter, 130
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x82
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0258:	BTFSC EECON1,WR
	GOTO L0258
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 733: 					Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0259
L0257:
; 734: 					EndSelect
L0259:
L0256:
; 735: 				Case 4, 5  'type with contact sliders, no twisting cables
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0260
L0251:
	MOVF 0x32,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0263
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0262
L0263:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0261
L0262:
; 736: 					steps = one_round - steps
	MOVF 0x34,W
	SUBWF 0x40,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x41,W
	MOVWF 0x35
; 737: 					direction = 1
	BSF 0x07,0
; 738: 				Case Else  'no short way possible
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0264
L0261:
; 739: 				EndSelect
L0264:
L0260:
; 740: 			Endif
L0250:
; 741: 		Endif
L0249:
; 742: 		If steps > 0 Then  'motor must be activated
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0265
; 743: 			If direction = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0266
; 744: 				steps = steps + free_space_word
	MOVF 0x34,W
	ADDWF 0x58,W
	MOVWF 0x34
	MOVF 0x35,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x59,W
	MOVWF 0x35
; 745: 			Endif
L0266:
; 746: 			ramp_up = 1
	BSF 0x3B,4
; 747: 			ramp_down_point = 0
	CLRF 0x53
	CLRF 0x54
; 748: 			half_steps = steps / 2
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x5A
	MOVF R0H,W
	MOVWF 0x5B
; 749: 			speed = speed_min
	MOVF 0x3D,W
	MOVWF 0x49
	MOVF 0x3E,W
	MOVWF 0x4A
; 750: 			ena = 1  'set enable on
	BSF 0x07,2
; 751: 			While steps > 0  'NOW RUN UNTIL STEPS = 0
L0267:
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0268
; 752: 				If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0269
; 753: 					Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 754: 				Endif
L0269:
; 755: 				Select Case ctrl_type
; 756: 				Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0270
; 757: 					If fy_stop = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0271
; 758: 						Gosub stop_the_motor
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0016
; 759: 					Endif
L0271:
; 760: 				Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0272
L0270:
; 761: 				EndSelect
L0272:
; 762: 				clk = 1  'clock out
	BSF 0x07,1
; 763: 				WaitUs speed
	MOVF 0x49,W
	MOVWF R4L
	MOVF 0x4A,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 764: 				clk = 0
	BCF 0x07,1
; 765: 				Gosub speed_calc
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0008
; 766: 				If new_pos = 0 And zero = 0 And use_zero_detector = 1 Then  'use zero detector to stop at position 0
	MOVF 0x48,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0273
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0273
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3B,3
	GOTO L0273
; 767: 					If direction = 1 Then  'going clockwise
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0274
; 768: 						While zero = 0  'run past zero detector
L0275:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0276
; 769: 							clk = 1  'clock out
	BSF 0x07,1
; 770: 							WaitUs speed
	MOVF 0x49,W
	MOVWF R4L
	MOVF 0x4A,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 771: 							clk = 0
	BCF 0x07,1
; 772: 							WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 773: 						Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0275
L0276:
; 774: 						WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 775: 						direction = 0  'now go counter clockwise
	BCF 0x07,0
; 776: 						value = 0
	CLRF 0x30
; 777: 						While zero = 1  'run until zero detector signals
L0277:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,3
	GOTO L0278
; 778: 							clk = 1
	BSF 0x07,1
; 779: 							WaitUs speed
	MOVF 0x49,W
	MOVWF R4L
	MOVF 0x4A,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 780: 							clk = 0
	BCF 0x07,1
; 781: 							WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 782: 							value = value + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 783: 						Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0277
L0278:
; 784: 						value = value / 4
	MOVF 0x30,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
; 785: 						If value > 99 Then
	MOVF 0x30,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0279
; 786: 							value = 99
	MOVLW 0x63
	MOVWF 0x30
; 787: 						Endif
L0279:
; 788: 						Write mem_free_space, value
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0280:	BTFSC EECON1,WR
	GOTO L0280
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 789: 						Gosub i2c_display  'show number of steps needed, indication of free_space_steps
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 790: 						WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 791: 					Endif
L0274:
; 792: 					steps = 0
	CLRF 0x34
	CLRF 0x35
; 793: 				Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0281
L0273:
; 794: 					If steps = 1 And new_pos = 0 And zero = 1 And use_zero_detector = 1 Then  'using zero detector, but at end of steps and detector not yet reached
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVLW 0x01
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0282
	MOVF 0x48,W
	SUBLW 0x00
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0282
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0282
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3B,3
	GOTO L0282
; 795: 						While zero = 1  'continue running until zero detector reached
L0283:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,3
	GOTO L0284
; 796: 							clk = 1  'clock out
	BSF 0x07,1
; 797: 							WaitUs speed
	MOVF 0x49,W
	MOVWF R4L
	MOVF 0x4A,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 798: 							clk = 0
	BCF 0x07,1
; 799: 						Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0283
L0284:
; 800: 						If direction = 1 Then  'going clockwise
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,0
	GOTO L0285
; 801: 							While zero = 0  'run past zero detector
L0286:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,3
	GOTO L0287
; 802: 								clk = 1  'clock out
	BSF 0x07,1
; 803: 								WaitUs speed
	MOVF 0x49,W
	MOVWF R4L
	MOVF 0x4A,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 804: 								clk = 0
	BCF 0x07,1
; 805: 								WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 806: 							Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0286
L0287:
; 807: 							WaitMs 200
	MOVLW 0xC8
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 808: 							direction = 0  'now go counter clockwise
	BCF 0x07,0
; 809: 							value = 0
	CLRF 0x30
; 810: 							While zero = 1  'run until zero detector signals
L0288:
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,3
	GOTO L0289
; 811: 								clk = 1
	BSF 0x07,1
; 812: 								WaitUs speed
	MOVF 0x49,W
	MOVWF R4L
	MOVF 0x4A,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 813: 								clk = 0
	BCF 0x07,1
; 814: 								WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 815: 								value = value + 1
	MOVF 0x30,W
	ADDLW 0x01
	MOVWF 0x30
; 816: 							Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0288
L0289:
; 817: 							value = value / 4
	MOVF 0x30,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x30
; 818: 							If value > 99 Then
	MOVF 0x30,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0290
; 819: 								value = 99
	MOVLW 0x63
	MOVWF 0x30
; 820: 							Endif
L0290:
; 821: 							Write mem_free_space, value
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0291:	BTFSC EECON1,WR
	GOTO L0291
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 822: 							Gosub i2c_display  'show number of steps needed, indication of free_space_steps
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 823: 							WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 824: 						Endif
L0285:
; 825: 						steps = 0
	CLRF 0x34
	CLRF 0x35
; 826: 					Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0292
L0282:
; 827: 						steps = steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 828: 					Endif
L0292:
; 829: 				Endif
L0281:
; 830: 			Wend
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0267
L0268:
; 831: 			WaitMs 1000  'NOW WAIT 1 SECOND BEFORE GO BACK
	MOVLW 0xE8
	MOVWF R0L
	MOVLW 0x03
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 832: 			If direction = 1 Then
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS 0x07,0
	GOTO L0293
; 833: 				steps = free_space_word
	MOVF 0x58,W
	MOVWF 0x34
	MOVF 0x59,W
	MOVWF 0x35
; 834: 				direction = 0  'now go back the free-space correction
	BCF 0x07,0
; 835: 				While steps > 0  'NOW RUN UNTIL STEPS = 0
L0294:
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0295
; 836: 					If max_end = 0 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x06,7
	GOTO L0296
; 837: 						Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 838: 					Endif
L0296:
; 839: 					Select Case ctrl_type
; 840: 					Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0297
; 841: 						If fy_stop = 1 Then
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x05,5
	GOTO L0298
; 842: 							Gosub stop_the_motor
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0016
; 843: 						Endif
L0298:
; 844: 					Case Else
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0299
L0297:
; 845: 					EndSelect
L0299:
; 846: 					clk = 1  'clock out
	BSF 0x07,1
; 847: 					WaitUs speed_min
	MOVF 0x3D,W
	MOVWF R4L
	MOVF 0x3E,W
	MOVWF R4H
;       PAGE SELECT
	BCF PCLATH,3
	CALL Y001
; 848: 					clk = 0
	BCF 0x07,1
; 849: 					steps = steps - 1
	MOVLW 0x01
	SUBWF 0x34,W
	MOVWF 0x34
	MOVLW 0x00
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x35,W
	MOVWF 0x35
; 850: 					WaitUs 5
	MOVLW 0x05
	MOVWF R4L
;       PAGE SELECT
;	BCF PCLATH,3
	CALL X001
; 851: 				Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0294
L0295:
; 852: 			Endif
L0293:
; 853: 			ena = 0  'enable off
	BCF 0x07,2
; 854: 		Endif
L0265:
; 855: 	Endif
L0232:
; 856: 	act_pos = new_pos
	MOVF 0x48,W
	MOVWF 0x31
; 857: 	Write mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0300:	BTFSC EECON1,WR
	GOTO L0300
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 858: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4B
; 859: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 860: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x3A
; 861: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 862: Return
	RETURN
; 863: 
; 864: speed_calc:
L0008:
; 865: 	If steps < half_steps Then  'at this point  ramp up MUST end
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x5A,W
	MOVWF R1L
	MOVF 0x5B,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0301
; 866: 		ramp_up = 0
	BCF 0x3B,4
; 867: 	Endif
L0301:
; 868: 	If ramp_up = 1 Then  'we were supposed to ramp up
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x3B,4
	GOTO L0302
; 869: 		If speed > speed_max Then
	MOVF 0x49,W
	MOVWF R0L
	MOVF 0x4A,W
	MOVWF R0H
	MOVF 0x38,W
	MOVWF R1L
	MOVF 0x39,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0303
; 870: 			speed = speed - speed_step
	MOVF 0x47,W
	SUBWF 0x49,W
	MOVWF 0x49
	CLRW
	BTFSS STATUS,C
	ADDLW 0x01
	SUBWF 0x4A,W
	MOVWF 0x4A
; 871: 			ramp_down_point = ramp_down_point + 1  'this counts down with the steps
	MOVF 0x53,W
	ADDLW 0x01
	MOVWF 0x53
	MOVF 0x54,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x54
; 872: 		Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0304
L0303:
; 873: 			ramp_up = 0
	BCF 0x3B,4
; 874: 		Endif
L0304:
; 875: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0305
L0302:
; 876: 		If steps < ramp_down_point Then  'this is the point tot start ramp down
	MOVF 0x34,W
	MOVWF R0L
	MOVF 0x35,W
	MOVWF R0H
	MOVF 0x53,W
	MOVWF R1L
	MOVF 0x54,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0306
; 877: 			If speed < speed_min Then
	MOVF 0x49,W
	MOVWF R0L
	MOVF 0x4A,W
	MOVWF R0H
	MOVF 0x3D,W
	MOVWF R1L
	MOVF 0x3E,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C004
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0307
; 878: 				speed = speed + speed_step
	MOVF 0x49,W
	ADDWF 0x47,W
	MOVWF 0x49
	MOVF 0x4A,W
	BTFSC STATUS,C
	ADDLW 0x01
	MOVWF 0x4A
; 879: 			Endif
L0307:
; 880: 		Endif
L0306:
; 881: 	Endif
L0305:
; 882: Return
	RETURN
; 883: 
; 884: set_relays:
L0009:
; 885: 	Gosub read_bridge_switch
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0013
; 886: 	If bridge_power = 0 Then  'bridge railpower must be switched on
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC 0x3B,2
	GOTO L0308
; 887: 		Select Case ctrl_type
; 888: 		Case 1, 3, 5, 6
	MOVF 0x32,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0311
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0310
L0311:
	MOVF 0x32,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0312
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0310
L0312:
	MOVF 0x32,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0313
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0310
L0313:
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0309
L0310:
; 889: 			swfw = 0
	BCF 0x06,0
; 890: 			swrev = 1
	BSF 0x06,1
; 891: 		Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0314
L0309:
; 892: 			swfw = bridge_switch
	BTFSC 0x3B,0
	BSF 0x06,0
	BTFSS 0x3B,0
	BCF 0x06,0
; 893: 			swrev = Not bridge_switch
	BTFSS 0x3B,0
	BSF 0x06,1
	BTFSC 0x3B,0
	BCF 0x06,1
; 894: 		EndSelect
L0314:
; 895: 	Else  'BRIDGE IS ALWAYS ON
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0315
L0308:
; 896: 		If bridge_switch <> old_bridge_switch Then  'polarisation must be changed
	CLRW
	BTFSC 0x3B,0
	ADDLW 0x01
	BTFSC 0x3B,6
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,Z
	GOTO L0316
; 897: 			swfw = bridge_switch
	BTFSC 0x3B,0
	BSF 0x06,0
	BTFSS 0x3B,0
	BCF 0x06,0
; 898: 			swrev = Not bridge_switch
	BTFSS 0x3B,0
	BSF 0x06,1
	BTFSC 0x3B,0
	BCF 0x06,1
; 899: 			old_bridge_switch = bridge_switch
	BTFSC 0x3B,0
	BSF 0x3B,6
	BTFSS 0x3B,0
	BCF 0x3B,6
; 900: 		Endif
L0316:
; 901: 	Endif
L0315:
; 902: Return
	RETURN
; 903: 
; 904: init_eeprom:
L0010:
; 905: 	If pgm = 0 Then  'special for my own fiddle yard
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC 0x07,7
	GOTO L0317
; 906: 		new_steps = 178
	MOVLW 0xB2
	MOVWF 0x36
	CLRF 0x37
; 907: 		For act_pos = 0 To 11
	CLRF 0x31
L0318:
	MOVF 0x31,W
	SUBLW 0x0B
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,C
	GOTO L0319
; 908: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0015
; 909: 			new_steps = new_steps + 4300
	MOVF 0x36,W
	ADDLW 0xCC
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x10
	MOVWF 0x37
; 910: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0318
L0319:
; 911: 		Write mem_max_pos, 11
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	MOVLW 0x0B
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0320:	BTFSC EECON1,WR
	GOTO L0320
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 912: 		max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 913: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0321
L0317:
; 914: 		new_steps = 0
	CLRF 0x36
	CLRF 0x37
; 915: 		steps = one_round / (max_pos + 1)  'devide the steps between min and max
	MOVF 0x33,W
	ADDLW 0x01
	MOVWF 0x34
	CLRW
	BTFSC STATUS,C
	ADDLW 0x01
	ADDLW 0x00
	MOVWF 0x35
	MOVF 0x40,W
	MOVWF R0L
	MOVF 0x41,W
	MOVWF R0H
	MOVF 0x34,W
	MOVWF R1L
	MOVF 0x35,W
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x34
	MOVF R0H,W
	MOVWF 0x35
; 916: 		For act_pos = 0 To max_pos
	CLRF 0x31
L0322:
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0323
; 917: 			Gosub save_steps
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0015
; 918: 			bridge_switch = 0
	BCF 0x3B,0
; 919: 			Gosub store_bridge_switch
;       PAGE SELECT
	BSF PCLATH,3
	CALL L0014
; 920: 			new_steps = new_steps + steps
	MOVF 0x36,W
	ADDWF 0x34,W
	MOVWF 0x36
	MOVF 0x37,W
	BTFSC STATUS,C
	ADDLW 0x01
	ADDWF 0x35,W
	MOVWF 0x37
; 921: 		Next act_pos
	MOVLW 0x01
	ADDWF 0x31,F
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,C
	GOTO L0322
L0323:
; 922: 	Endif
L0321:
; 923: 	act_pos = 0
	CLRF 0x31
; 924: 	Write mem_act_pos, act_pos  'act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0324:	BTFSC EECON1,WR
	GOTO L0324
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 925: Return
	RETURN
; 926: 
; 927: init_values:
L0011:
; 928: 	version = 0  'decimal point in display on
	BCF 0x3B,5
; 929: 	Gosub i2c_display
;       PAGE SELECT
	BCF PCLATH,3
	CALL L0005
; 930: 	WaitMs 3000
	MOVLW 0xB8
	MOVWF R0L
	MOVLW 0x0B
	MOVWF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 931: 	version = 1  'decimal point in display off
	BSF 0x3B,5
; 932: 	encoder_count = 0
	CLRF 0x4E
; 933: 	speed_min = 0
	CLRF 0x3D
	CLRF 0x3E
; 934: 	Read mem_speed_min, speed_min.HB
	MOVLW 0x67
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x3E
; 935: 	If speed_min.HB > 99 Then
	MOVF 0x3E,W
	SUBLW 0x63
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0325
; 936: 		speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3E
; 937: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0326
L0325:
; 938: 		If speed_min.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x3E,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0327
; 939: 			speed_min.HB = 40
	MOVLW 0x28
	MOVWF 0x3E
; 940: 		Endif
L0327:
; 941: 	Endif
L0326:
; 942: 	speed_max = 0
	CLRF 0x38
	CLRF 0x39
; 943: 	Read mem_speed_max, speed_max.HB
	MOVLW 0x68
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x39
; 944: 	If speed_max.HB > speed_min.HB Then
	MOVF 0x39,W
	SUBWF 0x3E,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0328
; 945: 		speed_max.HB = speed_min.HB
	MOVF 0x3E,W
	MOVWF 0x39
; 946: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0329
L0328:
; 947: 		If speed_max.HB < 1 Then
	MOVLW 0x01
	SUBWF 0x39,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0330
; 948: 			speed_max.HB = 6
	MOVLW 0x06
	MOVWF 0x39
; 949: 		Endif
L0330:
; 950: 	Endif
L0329:
; 951: 
; 952: 	Read mem_one_round_lb, one_round.LB
	MOVLW 0x6A
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x40
; 953: 	Read mem_one_round_hb, one_round.HB
	MOVLW 0x6B
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x41
; 954: 	If one_round = 0 Then
	MOVF 0x40,W
	MOVWF R0L
	MOVF 0x41,W
	MOVWF R0H
	CLRF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C001
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0331
; 955: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x40
	MOVLW 0x1F
	MOVWF 0x41
; 956: 	Endif
L0331:
; 957: 	If one_round > 60000 Then
	MOVF 0x40,W
	MOVWF R0L
	MOVF 0x41,W
	MOVWF R0H
	MOVLW 0x60
	MOVWF R1L
	MOVLW 0xEA
	MOVWF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL C003
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0332
; 958: 		one_round = 8000
	MOVLW 0x40
	MOVWF 0x40
	MOVLW 0x1F
	MOVWF 0x41
; 959: 	Endif
L0332:
; 960: 	one_round_half = one_round / 2
	MOVF 0x40,W
	MOVWF R0L
	MOVF 0x41,W
	MOVWF R0H
	MOVLW 0x02
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R0L,W
	MOVWF 0x55
	MOVF R0H,W
	MOVWF 0x56
; 961: 
; 962: 	Read mem_ctrl_type, ctrl_type
	MOVLW 0x6C
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x32
; 963: 	If ctrl_type > 6 Then
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
	BSF PCLATH,3
	BTFSC STATUS,C
	GOTO L0333
; 964: 		ctrl_type = 6
	MOVLW 0x06
	MOVWF 0x32
; 965: 	Endif
L0333:
; 966: 
; 967: 	Read mem_max_pos, max_pos
	MOVLW 0x6D
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x33
; 968: 	Select Case ctrl_type
; 969: 	Case 6
	MOVF 0x32,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0334
; 970: 		If max_pos > 30 Then
	MOVF 0x33,W
	SUBLW 0x1E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0335
; 971: 			max_pos = 12
	MOVLW 0x0C
	MOVWF 0x33
; 972: 		Endif
L0335:
; 973: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0336
L0334:
; 974: 		If max_pos > 47 Then
	MOVF 0x33,W
	SUBLW 0x2F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0337
; 975: 			max_pos = 47
	MOVLW 0x2F
	MOVWF 0x33
; 976: 		Endif
L0337:
; 977: 	EndSelect
L0336:
; 978: 	Read mem_act_pos, act_pos
	MOVLW 0x66
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x31
; 979: 	If act_pos > max_pos Then
	MOVF 0x31,W
	SUBWF 0x33,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0338
; 980: 		act_pos = 0
	CLRF 0x31
; 981: 	Endif
L0338:
; 982: 	Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 983: 	If free_space_steps > 99 Then
	MOVF 0x44,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0339
; 984: 		free_space_steps = 0
	CLRF 0x44
; 985: 	Endif
L0339:
; 986: 
; 987: 	Read mem_turn_counter, turn_counter
	MOVLW 0x65
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x42
; 988: 	If turn_counter > 131 Then  'in program impossible value
	MOVF 0x42,W
	SUBLW 0x83
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0340
; 989: 		turn_counter = 128
	MOVLW 0x80
	MOVWF 0x42
; 990: 	Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0341
L0340:
; 991: 		If turn_counter < 125 Then  'in program impossible value
	MOVLW 0x7D
	SUBWF 0x42,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0342
; 992: 			turn_counter = 128
	MOVLW 0x80
	MOVWF 0x42
; 993: 		Endif
L0342:
; 994: 	Endif
L0341:
; 995: 	
; 996: 	Read mem_speed_step, speed_step
	MOVLW 0x69
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x47
; 997: 	If speed_step > 99 Then
	MOVF 0x47,W
	SUBLW 0x63
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0343
; 998: 		speed_step = 0
	CLRF 0x47
; 999: 	Endif
L0343:
; 1000: 	
; 1001: 	Read mem_bridge_power, value
	MOVLW 0x70
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1002: 	If value > 3 Then
	MOVF 0x30,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0344
; 1003: 		value = 0
	CLRF 0x30
; 1004: 	Endif
L0344:
; 1005: 	bridge_power = value.0
	BTFSC 0x30,0
	BSF 0x3B,2
	BTFSS 0x30,0
	BCF 0x3B,2
; 1006: 	use_zero_detector = value.1
	BTFSC 0x30,1
	BSF 0x3B,3
	BTFSS 0x30,1
	BCF 0x3B,3
; 1007: 	
; 1008: 	If eep = 1 Then  'jumper set for initialisation
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x06,6
	GOTO L0345
; 1009: 		Gosub init_eeprom
;       PAGE SELECT
;	BCF PCLATH,3
	CALL L0010
; 1010: 	Endif
L0345:
; 1011: 	steps_set = 0
	BCF 0x3B,1
; 1012: 	new_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x48
; 1013: 	bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x4B
; 1014: 	old_bus_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x57
; 1015: 	manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x3A
; 1016: 	old_manual_pos = act_pos
	MOVF 0x31,W
	MOVWF 0x52
; 1017: Return
	RETURN
; 1018: 
; 1019: steps_reading:
L0012:
; 1020: 	Select Case new_pos
; 1021: 	Case 63
	MOVF 0x48,W
	SUBLW 0x3F
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0346
; 1022: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 1023: 		act_steps = 1
	MOVLW 0x01
	MOVWF 0x45
	CLRF 0x46
; 1024: 	Case 62
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0347
L0346:
	MOVF 0x48,W
	SUBLW 0x3E
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0348
; 1025: 		new_steps = 65534
	MOVLW 0xFE
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 1026: 		act_steps = 0
	CLRF 0x45
	CLRF 0x46
; 1027: 	Case 61
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0349
L0348:
	MOVF 0x48,W
	SUBLW 0x3D
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0350
; 1028: 		new_steps = 65533
	MOVLW 0xFD
	MOVWF 0x36
	MOVLW 0xFF
	MOVWF 0x37
; 1029: 		act_steps = 0
	CLRF 0x45
	CLRF 0x46
; 1030: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0351
L0350:
; 1031: 		eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 1032: 		Read act_pos, act_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x45
; 1033: 		Read eprom_pointer, act_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x46
; 1034: 		eprom_pointer = new_pos + 48
	MOVF 0x48,W
	ADDLW 0x30
	MOVWF 0x50
; 1035: 		Read new_pos, new_steps.LB
	MOVF 0x48,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x36
; 1036: 		Read eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x37
; 1037: 		Read mem_free_space, free_space_steps
	MOVLW 0x6E
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x44
; 1038: 		free_space_word = free_space_steps * 4
	MOVF 0x44,W
	MOVWF R3L
	CLRF R3H
	MOVLW 0x04
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL M001
	MOVF R2L,W
	MOVWF 0x58
	MOVF R2H,W
	MOVWF 0x59
; 1039: 	EndSelect
L0351:
L0349:
L0347:
; 1040: Return
	RETURN
; 1041: 
; 1042: read_bridge_switch:
L0013:
; 1043: 	Select Case act_pos
; 1044: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0352
; 1045: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1046: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0353
L0352:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0354
; 1047: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1048: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0355
L0354:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0356
; 1049: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1050: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0357
L0356:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0358
; 1051: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1052: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0359
L0358:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0360
; 1053: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1054: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0361
L0360:
; 1055: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1056: 	EndSelect
L0361:
L0359:
L0357:
L0355:
L0353:
; 1057: 	value2 = act_pos Mod 8
	MOVF 0x31,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x3C
; 1058: 	Select Case value2
; 1059: 	Case 0
	MOVF 0x3C,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0362
; 1060: 		bridge_switch = value.0
	BTFSC 0x30,0
	BSF 0x3B,0
	BTFSS 0x30,0
	BCF 0x3B,0
; 1061: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0363
L0362:
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0364
; 1062: 		bridge_switch = value.1
	BTFSC 0x30,1
	BSF 0x3B,0
	BTFSS 0x30,1
	BCF 0x3B,0
; 1063: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0365
L0364:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0366
; 1064: 		bridge_switch = value.2
	BTFSC 0x30,2
	BSF 0x3B,0
	BTFSS 0x30,2
	BCF 0x3B,0
; 1065: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0367
L0366:
	MOVF 0x3C,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0368
; 1066: 		bridge_switch = value.3
	BTFSC 0x30,3
	BSF 0x3B,0
	BTFSS 0x30,3
	BCF 0x3B,0
; 1067: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0369
L0368:
	MOVF 0x3C,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0370
; 1068: 		bridge_switch = value.4
	BTFSC 0x30,4
	BSF 0x3B,0
	BTFSS 0x30,4
	BCF 0x3B,0
; 1069: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0371
L0370:
	MOVF 0x3C,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0372
; 1070: 		bridge_switch = value.5
	BTFSC 0x30,5
	BSF 0x3B,0
	BTFSS 0x30,5
	BCF 0x3B,0
; 1071: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0373
L0372:
	MOVF 0x3C,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0374
; 1072: 		bridge_switch = value.6
	BTFSC 0x30,6
	BSF 0x3B,0
	BTFSS 0x30,6
	BCF 0x3B,0
; 1073: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0375
L0374:
; 1074: 		bridge_switch = value.7
	BTFSC 0x30,7
	BSF 0x3B,0
	BTFSS 0x30,7
	BCF 0x3B,0
; 1075: 	EndSelect
L0375:
L0373:
L0371:
L0369:
L0367:
L0365:
L0363:
; 1076: Return
	RETURN
; 1077: 
; 1078: store_bridge_switch:
L0014:
; 1079: 	Select Case act_pos
; 1080: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0376
; 1081: 		Read mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1082: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0377
L0376:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0378
; 1083: 		Read mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1084: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0379
L0378:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0380
; 1085: 		Read mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1086: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0381
L0380:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0382
; 1087: 		Read mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1088: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0383
L0382:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0384
; 1089: 		Read mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1090: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0385
L0384:
; 1091: 		Read mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,RD
	NOP
	BCF STATUS,RP0
	MOVF EEDATA,W
	BCF STATUS,RP1
	MOVWF 0x30
; 1092: 	EndSelect
L0385:
L0383:
L0381:
L0379:
L0377:
; 1093: 	value2 = act_pos
	MOVF 0x31,W
	MOVWF 0x3C
; 1094: 	value2 = value2 Mod 8
	MOVF 0x3C,W
	MOVWF R0L
	CLRF R0H
	MOVLW 0x08
	MOVWF R1L
	CLRF R1H
;       PAGE SELECT
	BCF PCLATH,3
	CALL D001
	MOVF R2L,W
	MOVWF 0x3C
; 1095: 	Select Case value2
; 1096: 	Case 0
	MOVF 0x3C,W
	SUBLW 0x00
;       PAGE SELECT
	BSF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0386
; 1097: 		value.0 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,0
	BTFSS 0x3B,0
	BCF 0x30,0
; 1098: 	Case 1
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0387
L0386:
	MOVF 0x3C,W
	SUBLW 0x01
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0388
; 1099: 		value.1 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,1
	BTFSS 0x3B,0
	BCF 0x30,1
; 1100: 	Case 2
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0389
L0388:
	MOVF 0x3C,W
	SUBLW 0x02
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0390
; 1101: 		value.2 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,2
	BTFSS 0x3B,0
	BCF 0x30,2
; 1102: 	Case 3
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0391
L0390:
	MOVF 0x3C,W
	SUBLW 0x03
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0392
; 1103: 		value.3 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,3
	BTFSS 0x3B,0
	BCF 0x30,3
; 1104: 	Case 4
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0393
L0392:
	MOVF 0x3C,W
	SUBLW 0x04
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0394
; 1105: 		value.4 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,4
	BTFSS 0x3B,0
	BCF 0x30,4
; 1106: 	Case 5
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0395
L0394:
	MOVF 0x3C,W
	SUBLW 0x05
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0396
; 1107: 		value.5 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,5
	BTFSS 0x3B,0
	BCF 0x30,5
; 1108: 	Case 6
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0397
L0396:
	MOVF 0x3C,W
	SUBLW 0x06
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS STATUS,Z
	GOTO L0398
; 1109: 		value.6 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,6
	BTFSS 0x3B,0
	BCF 0x30,6
; 1110: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0399
L0398:
; 1111: 		value.7 = bridge_switch
	BTFSC 0x3B,0
	BSF 0x30,7
	BTFSS 0x3B,0
	BCF 0x30,7
; 1112: 	EndSelect
L0399:
L0397:
L0395:
L0393:
L0391:
L0389:
L0387:
; 1113: 	Select Case act_pos
; 1114: 	Case < 8
	MOVLW 0x08
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0400
; 1115: 		Write mem_bridge_switch1, value
	MOVLW 0x71
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0401:	BTFSC EECON1,WR
	GOTO L0401
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1116: 	Case < 16
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0402
L0400:
	MOVLW 0x10
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0403
; 1117: 		Write mem_bridge_switch2, value
	MOVLW 0x72
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0404:	BTFSC EECON1,WR
	GOTO L0404
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1118: 	Case < 24
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0405
L0403:
	MOVLW 0x18
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0406
; 1119: 		Write mem_bridge_switch3, value
	MOVLW 0x73
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0407:	BTFSC EECON1,WR
	GOTO L0407
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1120: 	Case < 32
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0408
L0406:
	MOVLW 0x20
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0409
; 1121: 		Write mem_bridge_switch4, value
	MOVLW 0x74
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0410:	BTFSC EECON1,WR
	GOTO L0410
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1122: 	Case < 40
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0411
L0409:
	MOVLW 0x28
	SUBWF 0x31,W
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSC STATUS,C
	GOTO L0412
; 1123: 		Write mem_bridge_switch5, value
	MOVLW 0x75
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0413:	BTFSC EECON1,WR
	GOTO L0413
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1124: 	Case Else
;       PAGE SELECT
;	BCF PCLATH,3
	GOTO L0414
L0412:
; 1125: 		Write mem_bridge_switch6, value
	MOVLW 0x76
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x30,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0415:	BTFSC EECON1,WR
	GOTO L0415
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1126: 	EndSelect
L0414:
L0411:
L0408:
L0405:
L0402:
; 1127: Return
	RETURN
; 1128: 
; 1129: save_steps:
L0015:
; 1130: 	eprom_pointer = act_pos + 48
	MOVF 0x31,W
	ADDLW 0x30
	MOVWF 0x50
; 1131: 	Write act_pos, new_steps.LB
	MOVF 0x31,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x36,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0416:	BTFSC EECON1,WR
	GOTO L0416
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1132: 	Write eprom_pointer, new_steps.HB
	MOVF 0x50,W
	BSF STATUS,RP1
	MOVWF EEADR
	BCF STATUS,RP1
	MOVF 0x37,W
	BSF STATUS,RP1
	MOVWF EEDATA
	BSF STATUS,RP0
	BCF EECON1,EEPGD
	BSF EECON1,WREN
	MOVLW 0x55
	MOVWF EECON2
	MOVLW 0xAA
	MOVWF EECON2
	BSF EECON1,WR
;       PAGE SELECT
;	BCF PCLATH,3
L0417:	BTFSC EECON1,WR
	GOTO L0417
	BCF EECON1,WREN
	BCF STATUS,RP1
	BCF STATUS,RP0
	BCF PIR2,EEIF
; 1133: Return
	RETURN
; 1134: 
; 1135: stop_the_motor:
L0016:
; 1136: 	While ecsw = 1
L0418:
;       PAGE SELECT
;	BCF PCLATH,3
	BTFSS 0x07,6
	GOTO L0419
; 1137: 		WaitMs 250
	MOVLW 0xFA
	MOVWF R0L
	CLRF R0H
;       PAGE SELECT
	BCF PCLATH,3
	CALL W001
; 1138: 	Wend
;       PAGE SELECT
	BSF PCLATH,3
	GOTO L0418
L0419:
; 1139: Return
	RETURN
; End of program
;       PAGE SELECT
;	BCF PCLATH,3
L0420:	GOTO L0420
; Configuration word settings
	ORG 0x2007
	DW 0x3F72
; End of listing
	END
